/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import net.named_data.jndn.Data;
import net.named_data.jndn.DigestSha256Signature;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.OnDataValidationFailed;
import net.named_data.jndn.security.OnInterestValidationFailed;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.VerificationHelpers;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.SignedBlob;

public abstract class PolicyManager {
    public abstract boolean skipVerifyAndTrust(Data var1);

    public abstract boolean skipVerifyAndTrust(Interest var1);

    public abstract boolean requireVerify(Data var1);

    public abstract boolean requireVerify(Interest var1);

    public abstract ValidationRequest checkVerificationPolicy(Data var1, int var2, OnVerified var3, OnDataValidationFailed var4) throws SecurityException;

    public abstract ValidationRequest checkVerificationPolicy(Interest var1, int var2, OnVerifiedInterest var3, OnInterestValidationFailed var4, WireFormat var5) throws SecurityException;

    public ValidationRequest checkVerificationPolicy(Interest interest, int stepCount, OnVerifiedInterest onVerified, OnInterestValidationFailed onValidationFailed) throws SecurityException {
        return this.checkVerificationPolicy(interest, stepCount, onVerified, onValidationFailed, WireFormat.getDefaultWireFormat());
    }

    public abstract boolean checkSigningPolicy(Name var1, Name var2);

    public abstract Name inferSigningIdentity(Name var1);

    protected static boolean verifySignature(Signature signature, SignedBlob signedBlob, Blob publicKeyDer) throws SecurityException {
        if (signature instanceof Sha256WithRsaSignature || signature instanceof Sha256WithEcdsaSignature) {
            if (publicKeyDer.isNull()) {
                return false;
            }
            return VerificationHelpers.verifySignature(signedBlob.signedBuf(), signature.getSignature(), new PublicKey(publicKeyDer), DigestAlgorithm.SHA256);
        }
        if (signature instanceof DigestSha256Signature) {
            return VerificationHelpers.verifyDigest(signedBlob.signedBuf(), signature.getSignature(), DigestAlgorithm.SHA256);
        }
        throw new SecurityException("PolicyManager.verify: Signature type is unknown");
    }
}

