/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib.detail;

import java.nio.ByteBuffer;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibCertificateContainer;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;

public class PibKeyImpl {
    private final Name identityName_;
    private final Name keyName_;
    private final Blob keyEncoding_;
    private final KeyType keyType_;
    private CertificateV2 defaultCertificate_ = null;
    private final PibCertificateContainer certificates_;
    private final PibImpl pibImpl_;

    public PibKeyImpl(Name keyName, ByteBuffer keyEncoding, PibImpl pibImpl) throws PibImpl.Error {
        this.identityName_ = PibKey.extractIdentityFromKeyName(keyName);
        this.keyName_ = new Name(keyName);
        this.keyEncoding_ = new Blob(keyEncoding, true);
        this.certificates_ = new PibCertificateContainer(keyName, pibImpl);
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
        try {
            PublicKey publicKey = new PublicKey(this.keyEncoding_);
            this.keyType_ = publicKey.getKeyType();
        }
        catch (UnrecognizedKeyFormatException ex) {
            throw new IllegalArgumentException("Invalid key encoding");
        }
        this.pibImpl_.addKey(this.identityName_, this.keyName_, keyEncoding);
    }

    public PibKeyImpl(Name keyName, PibImpl pibImpl) throws Pib.Error, PibImpl.Error {
        PublicKey publicKey;
        this.identityName_ = PibKey.extractIdentityFromKeyName(keyName);
        this.keyName_ = new Name(keyName);
        this.certificates_ = new PibCertificateContainer(keyName, pibImpl);
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
        this.keyEncoding_ = this.pibImpl_.getKeyBits(this.keyName_);
        try {
            publicKey = new PublicKey(this.keyEncoding_);
        }
        catch (UnrecognizedKeyFormatException ex) {
            throw new Pib.Error("Error decoding public key: " + ex);
        }
        this.keyType_ = publicKey.getKeyType();
    }

    public final Name getName() {
        return this.keyName_;
    }

    public final Name getIdentityName() {
        return this.identityName_;
    }

    public final KeyType getKeyType() {
        return this.keyType_;
    }

    public final Blob getPublicKey() {
        return this.keyEncoding_;
    }

    public final void addCertificate(CertificateV2 certificate) throws CertificateV2.Error, PibImpl.Error {
        this.certificates_.add(certificate);
    }

    public final void removeCertificate(Name certificateName) throws PibImpl.Error {
        if (this.defaultCertificate_ != null && this.defaultCertificate_.getName().equals(certificateName)) {
            this.defaultCertificate_ = null;
        }
        this.certificates_.remove(certificateName);
    }

    public final CertificateV2 getCertificate(Name certificateName) throws Pib.Error, PibImpl.Error {
        return this.certificates_.get(certificateName);
    }

    public final CertificateV2 setDefaultCertificate(Name certificateName) throws Pib.Error, PibImpl.Error {
        this.defaultCertificate_ = this.certificates_.get(certificateName);
        this.pibImpl_.setDefaultCertificateOfKey(this.keyName_, certificateName);
        return this.defaultCertificate_;
    }

    public final CertificateV2 setDefaultCertificate(CertificateV2 certificate) throws CertificateV2.Error, PibImpl.Error, Pib.Error {
        this.addCertificate(certificate);
        return this.setDefaultCertificate(certificate.getName());
    }

    public final CertificateV2 getDefaultCertificate() throws Pib.Error, PibImpl.Error {
        if (this.defaultCertificate_ == null) {
            this.defaultCertificate_ = this.pibImpl_.getDefaultCertificateOfKey(this.keyName_);
        }
        return this.defaultCertificate_;
    }

    public final PibCertificateContainer getCertificates_() {
        return this.certificates_;
    }
}

