/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;

public class PibMemory
extends PibImpl {
    private String tpmLocator_ = "";
    private Name defaultIdentityName_ = null;
    private final HashSet<Name> identityNames_ = new HashSet();
    private final HashMap<Name, Name> defaultKeyNames_ = new HashMap();
    private final HashMap<Name, Blob> keys_ = new HashMap();
    private final HashMap<Name, Name> defaultCertificateNames_ = new HashMap();
    private final HashMap<Name, CertificateV2> certificates_ = new HashMap();

    public static String getScheme() {
        return "pib-memory";
    }

    @Override
    public void setTpmLocator(String tpmLocator) throws PibImpl.Error {
        this.tpmLocator_ = tpmLocator;
    }

    @Override
    public String getTpmLocator() throws PibImpl.Error {
        return this.tpmLocator_;
    }

    @Override
    public boolean hasIdentity(Name identityName) throws PibImpl.Error {
        return this.identityNames_.contains(identityName);
    }

    @Override
    public void addIdentity(Name identityName) throws PibImpl.Error {
        Name identityNameCopy = new Name(identityName);
        this.identityNames_.add(identityNameCopy);
        if (this.defaultIdentityName_ == null) {
            this.defaultIdentityName_ = identityNameCopy;
        }
    }

    @Override
    public void removeIdentity(Name identityName) throws PibImpl.Error {
        this.identityNames_.remove(identityName);
        if (this.defaultIdentityName_ != null && identityName.equals(this.defaultIdentityName_)) {
            this.defaultIdentityName_ = null;
        }
        for (Name keyName : this.getKeysOfIdentity(identityName)) {
            this.removeKey(keyName);
        }
    }

    @Override
    public void clearIdentities() throws PibImpl.Error {
        this.defaultIdentityName_ = null;
        this.identityNames_.clear();
        this.defaultKeyNames_.clear();
        this.keys_.clear();
        this.defaultCertificateNames_.clear();
        this.certificates_.clear();
    }

    @Override
    public HashSet<Name> getIdentities() throws PibImpl.Error {
        HashSet<Name> result = new HashSet<Name>();
        for (Name name : this.identityNames_) {
            result.add(new Name(name));
        }
        return result;
    }

    @Override
    public void setDefaultIdentity(Name identityName) throws PibImpl.Error {
        this.addIdentity(identityName);
        this.defaultIdentityName_ = new Name(identityName);
    }

    @Override
    public Name getDefaultIdentity() throws Pib.Error, PibImpl.Error {
        if (this.defaultIdentityName_ != null) {
            return new Name(this.defaultIdentityName_);
        }
        throw new Pib.Error("No default identity");
    }

    @Override
    public boolean hasKey(Name keyName) throws PibImpl.Error {
        return this.keys_.containsKey(keyName);
    }

    @Override
    public void addKey(Name identityName, Name keyName, ByteBuffer key) throws PibImpl.Error {
        this.addIdentity(identityName);
        Name keyNameCopy = new Name(keyName);
        this.keys_.put(keyNameCopy, new Blob(key, true));
        if (!this.defaultKeyNames_.containsKey(identityName)) {
            this.defaultKeyNames_.put(new Name(identityName), keyNameCopy);
        }
    }

    @Override
    public void removeKey(Name keyName) throws PibImpl.Error {
        Name identityName = PibKey.extractIdentityFromKeyName(keyName);
        this.keys_.remove(keyName);
        this.defaultKeyNames_.remove(identityName);
        for (Name certificateName : this.getCertificatesOfKey(keyName)) {
            this.removeCertificate(certificateName);
        }
    }

    @Override
    public Blob getKeyBits(Name keyName) throws Pib.Error, PibImpl.Error {
        if (!this.hasKey(keyName)) {
            throw new Pib.Error("Key `" + keyName.toUri() + "` not found");
        }
        Blob key = this.keys_.get(keyName);
        if (key == null) {
            throw new Pib.Error("keyName not found");
        }
        return key;
    }

    @Override
    public HashSet<Name> getKeysOfIdentity(Name identityName) throws PibImpl.Error {
        HashSet<Name> ids = new HashSet<Name>();
        for (Name keyName : this.keys_.keySet()) {
            if (!identityName.equals(PibKey.extractIdentityFromKeyName(keyName))) continue;
            ids.add(new Name(keyName));
        }
        return ids;
    }

    @Override
    public void setDefaultKeyOfIdentity(Name identityName, Name keyName) throws Pib.Error, PibImpl.Error {
        if (!this.hasKey(keyName)) {
            throw new Pib.Error("Key `" + keyName.toUri() + "` not found");
        }
        this.defaultKeyNames_.put(new Name(identityName), new Name(keyName));
    }

    @Override
    public Name getDefaultKeyOfIdentity(Name identityName) throws Pib.Error, PibImpl.Error {
        Name defaultKey = this.defaultKeyNames_.get(identityName);
        if (defaultKey == null) {
            throw new Pib.Error("No default key for identity `" + identityName.toUri() + "`");
        }
        return new Name(defaultKey);
    }

    @Override
    public boolean hasCertificate(Name certificateName) throws PibImpl.Error {
        return this.certificates_.containsKey(certificateName);
    }

    @Override
    public void addCertificate(CertificateV2 certificate) throws PibImpl.Error {
        Name certificateNameCopy = new Name(certificate.getName());
        Name keyNameCopy = certificate.getKeyName();
        Name identity = certificate.getIdentity();
        this.addKey(identity, keyNameCopy, certificate.getContent().buf());
        try {
            this.certificates_.put(certificateNameCopy, new CertificateV2(certificate));
        }
        catch (CertificateV2.Error ex) {
            throw new PibImpl.Error(ex.getMessage());
        }
        if (!this.defaultCertificateNames_.containsKey(keyNameCopy)) {
            this.defaultCertificateNames_.put(keyNameCopy, certificateNameCopy);
        }
    }

    @Override
    public void removeCertificate(Name certificateName) throws PibImpl.Error {
        this.certificates_.remove(certificateName);
        Name keyName = CertificateV2.extractKeyNameFromCertName(certificateName);
        Name defaultCertificateName = this.defaultCertificateNames_.get(keyName);
        if (defaultCertificateName != null && defaultCertificateName.equals(certificateName)) {
            this.defaultCertificateNames_.remove(keyName);
        }
    }

    @Override
    public CertificateV2 getCertificate(Name certificateName) throws Pib.Error, PibImpl.Error {
        if (!this.hasCertificate(certificateName)) {
            throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exist");
        }
        try {
            return new CertificateV2(this.certificates_.get(certificateName));
        }
        catch (CertificateV2.Error ex) {
            throw new PibImpl.Error(ex.getMessage());
        }
    }

    @Override
    public HashSet<Name> getCertificatesOfKey(Name keyName) throws PibImpl.Error {
        HashSet<Name> certificateNames = new HashSet<Name>();
        for (Name certificateName : this.certificates_.keySet()) {
            if (!CertificateV2.extractKeyNameFromCertName(this.certificates_.get(certificateName).getName()).equals(keyName)) continue;
            certificateNames.add(new Name(certificateName));
        }
        return certificateNames;
    }

    @Override
    public void setDefaultCertificateOfKey(Name keyName, Name certificateName) throws Pib.Error, PibImpl.Error {
        if (!this.hasCertificate(certificateName)) {
            throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exist");
        }
        this.defaultCertificateNames_.put(new Name(keyName), new Name(certificateName));
    }

    @Override
    public CertificateV2 getDefaultCertificateOfKey(Name keyName) throws Pib.Error, PibImpl.Error {
        Name certificateName = this.defaultCertificateNames_.get(keyName);
        if (certificateName == null) {
            throw new Pib.Error("No default certificate for key `" + keyName.toUri() + "`");
        }
        CertificateV2 certificate = this.certificates_.get(certificateName);
        if (certificate == null) {
            throw new Pib.Error("certificate not found");
        }
        try {
            return new CertificateV2(certificate);
        }
        catch (CertificateV2.Error ex) {
            throw new PibImpl.Error(ex.getMessage());
        }
    }
}

