/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.pib.detail.PibKeyImpl;
import net.named_data.jndn.util.Common;

public class PibKeyContainer {
    private final Name identityName_;
    private final HashSet<Name> keyNames_;
    private final HashMap<Name, PibKeyImpl> keys_ = new HashMap();
    private final PibImpl pibImpl_;
    private static Common dummyCommon_ = new Common();

    public final int size() {
        return this.keyNames_.size();
    }

    public final PibKey add(ByteBuffer key, Name keyName) throws PibImpl.Error, Pib.Error {
        if (!this.identityName_.equals(PibKey.extractIdentityFromKeyName(keyName))) {
            throw new IllegalArgumentException("The key name `" + keyName.toUri() + "` does not match the identity name `" + this.identityName_.toUri() + "`");
        }
        this.keyNames_.add(new Name(keyName));
        this.keys_.put(new Name(keyName), new PibKeyImpl(keyName, key, this.pibImpl_));
        return this.get(keyName);
    }

    public final void remove(Name keyName) throws PibImpl.Error {
        if (!this.identityName_.equals(PibKey.extractIdentityFromKeyName(keyName))) {
            throw new IllegalArgumentException("Key name `" + keyName.toUri() + "` does not match identity `" + this.identityName_.toUri() + "`");
        }
        this.keyNames_.remove(keyName);
        this.keys_.remove(keyName);
        this.pibImpl_.removeKey(keyName);
    }

    public final PibKey get(Name keyName) throws Pib.Error, PibImpl.Error {
        if (!this.identityName_.equals(PibKey.extractIdentityFromKeyName(keyName))) {
            throw new IllegalArgumentException("Key name `" + keyName.toUri() + "` does not match identity `" + this.identityName_.toUri() + "`");
        }
        PibKeyImpl pibKeyImpl = this.keys_.get(keyName);
        if (pibKeyImpl == null) {
            pibKeyImpl = new PibKeyImpl(keyName, this.pibImpl_);
            this.keys_.put(new Name(keyName), pibKeyImpl);
        }
        return new PibKey(pibKeyImpl);
    }

    public final ArrayList<Name> getKeyNames() {
        ArrayList<Name> result = new ArrayList<Name>();
        for (Name name : this.keys_.keySet()) {
            result.add(new Name(name));
        }
        return result;
    }

    public final boolean isConsistent() throws PibImpl.Error {
        return this.keyNames_.equals(this.pibImpl_.getKeysOfIdentity(this.identityName_));
    }

    public PibKeyContainer(Name identityName, PibImpl pibImpl) throws PibImpl.Error {
        this.identityName_ = new Name(identityName);
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
        this.keyNames_ = this.pibImpl_.getKeysOfIdentity(identityName);
    }

    public final HashMap<Name, PibKeyImpl> getKeys_() {
        return this.keys_;
    }
}

