/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import java.util.HashMap;
import java.util.HashSet;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Common;

public class PibCertificateContainer {
    private final Name keyName_;
    private HashSet<Name> certificateNames_;
    private final HashMap<Name, CertificateV2> certificates_ = new HashMap();
    private final PibImpl pibImpl_;
    private static Common dummyCommon_ = new Common();

    public final int size() {
        return this.certificateNames_.size();
    }

    public final void add(CertificateV2 certificate) throws CertificateV2.Error, PibImpl.Error {
        if (!this.keyName_.equals(certificate.getKeyName())) {
            throw new IllegalArgumentException("The certificate name `" + certificate.getKeyName().toUri() + "` does not match the key name");
        }
        Name certificateName = new Name(certificate.getName());
        this.certificateNames_.add(certificateName);
        this.certificates_.put(certificateName, new CertificateV2(certificate));
        this.pibImpl_.addCertificate(certificate);
    }

    public final void remove(Name certificateName) throws PibImpl.Error {
        if (!CertificateV2.isValidName(certificateName) || !CertificateV2.extractKeyNameFromCertName(certificateName).equals(this.keyName_)) {
            throw new IllegalArgumentException("Certificate name `" + certificateName.toUri() + "` is invalid or does not match key name");
        }
        this.certificateNames_.remove(certificateName);
        this.certificates_.remove(certificateName);
        this.pibImpl_.removeCertificate(certificateName);
    }

    public final CertificateV2 get(Name certificateName) throws Pib.Error, PibImpl.Error {
        CertificateV2 cachedCertificate = this.certificates_.get(certificateName);
        if (cachedCertificate != null) {
            try {
                return new CertificateV2(cachedCertificate);
            }
            catch (CertificateV2.Error ex) {
                throw new Pib.Error("Error copying certificate: " + ex);
            }
        }
        if (!CertificateV2.isValidName(certificateName) || !CertificateV2.extractKeyNameFromCertName(certificateName).equals(this.keyName_)) {
            throw new IllegalArgumentException("Certificate name `" + certificateName.toUri() + "` is invalid or does not match key name");
        }
        CertificateV2 certificate = this.pibImpl_.getCertificate(certificateName);
        this.certificates_.put(new Name(certificateName), certificate);
        try {
            return new CertificateV2(certificate);
        }
        catch (CertificateV2.Error ex) {
            throw new Pib.Error("Error copying certificate: " + ex);
        }
    }

    public final boolean isConsistent() throws PibImpl.Error {
        return this.certificateNames_.equals(this.pibImpl_.getCertificatesOfKey(this.keyName_));
    }

    public PibCertificateContainer(Name keyName, PibImpl pibImpl) throws PibImpl.Error {
        this.keyName_ = new Name(keyName);
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
        this.certificateNames_ = this.pibImpl_.getCertificatesOfKey(keyName);
    }

    public final HashMap<Name, CertificateV2> getCertificates_() {
        return this.certificates_;
    }
}

