/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.Sqlite3IdentityStorageBase;
import net.named_data.jndn.util.Blob;

public class AndroidSqlite3IdentityStorage
extends Sqlite3IdentityStorageBase {
    private SQLiteDatabase database_;
    private static final SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AndroidSqlite3IdentityStorage(String databaseFilePath) {
        this.construct(databaseFilePath);
    }

    public static String getDefaultFilePath(File filesRoot) {
        return AndroidSqlite3IdentityStorage.getDefaultFilePath(filesRoot.getAbsolutePath());
    }

    public static String getDefaultFilePath(String filesRoot) {
        File identityDir = new File(filesRoot, ".ndn");
        identityDir.mkdirs();
        return new File(identityDir, "ndnsec-public-info.db").getAbsolutePath();
    }

    private void construct(String databaseFilePath) {
        this.database_ = SQLiteDatabase.openDatabase((String)databaseFilePath, null, (int)0x10000000);
        Cursor cursor = this.database_.rawQuery("SELECT name FROM sqlite_master WHERE type='table' And name='TpmInfo'", null);
        boolean tpmInfoTableExists = false;
        if (cursor.moveToNext()) {
            tpmInfoTableExists = true;
        }
        cursor.close();
        if (!tpmInfoTableExists) {
            this.database_.execSQL("CREATE TABLE IF NOT EXISTS                                           \n  TpmInfo(                                                           \n      tpm_locator BLOB NOT NULL,                                     \n      PRIMARY KEY (tpm_locator)                                      \n  );                                                                 \n");
        }
        cursor = this.database_.rawQuery("SELECT name FROM sqlite_master WHERE type='table' And name='Identity'", null);
        boolean idTableExists = false;
        if (cursor.moveToNext()) {
            idTableExists = true;
        }
        cursor.close();
        if (!idTableExists) {
            this.database_.execSQL("CREATE TABLE IF NOT EXISTS                                           \n  Identity(                                                          \n      identity_name     BLOB NOT NULL,                               \n      default_identity  INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (identity_name)                                    \n  );                                                                 \n                                                                     \n");
            this.database_.execSQL("CREATE INDEX identity_index ON Identity(identity_name);              \n");
        }
        cursor = this.database_.rawQuery("SELECT name FROM sqlite_master WHERE type='table' And name='Key'", null);
        idTableExists = false;
        if (cursor.moveToNext()) {
            idTableExists = true;
        }
        cursor.close();
        if (!idTableExists) {
            this.database_.execSQL("CREATE TABLE IF NOT EXISTS                                           \n  Key(                                                               \n      identity_name     BLOB NOT NULL,                               \n      key_identifier    BLOB NOT NULL,                               \n      key_type          INTEGER,                                     \n      public_key        BLOB,                                        \n      default_key       INTEGER DEFAULT 0,                           \n      active            INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (identity_name, key_identifier)                    \n  );                                                                 \n                                                                     \n");
            this.database_.execSQL("CREATE INDEX key_index ON Key(identity_name);                        \n");
        }
        cursor = this.database_.rawQuery("SELECT name FROM sqlite_master WHERE type='table' And name='Certificate'", null);
        idTableExists = false;
        if (cursor.moveToNext()) {
            idTableExists = true;
        }
        cursor.close();
        if (!idTableExists) {
            this.database_.execSQL("CREATE TABLE IF NOT EXISTS                                           \n  Certificate(                                                       \n      cert_name         BLOB NOT NULL,                               \n      cert_issuer       BLOB NOT NULL,                               \n      identity_name     BLOB NOT NULL,                               \n      key_identifier    BLOB NOT NULL,                               \n      not_before        TIMESTAMP,                                   \n      not_after         TIMESTAMP,                                   \n      certificate_data  BLOB NOT NULL,                               \n      valid_flag        INTEGER DEFAULT 1,                           \n      default_cert      INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (cert_name)                                        \n  );                                                                 \n                                                                     \n");
            this.database_.execSQL("CREATE INDEX cert_index ON Certificate(cert_name);           \n");
            this.database_.execSQL("CREATE INDEX subject ON Certificate(identity_name);          \n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean doesIdentityExist(Name identityName) throws SecurityException {
        try (Cursor cursor = this.database_.rawQuery("SELECT count(*) FROM Identity WHERE identity_name=?", new String[]{identityName.toUri()});){
            if (cursor.moveToNext()) {
                boolean bl = cursor.getInt(0) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public final void addIdentity(Name identityName) throws SecurityException {
        if (this.doesIdentityExist(identityName)) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("identity_name", identityName.toUri());
        if (this.database_.insert("Identity", null, values) < 0L) {
            throw new SecurityException("AndroidSqlite3IdentityStorage.addIdentity: SQLite error for insert");
        }
    }

    @Override
    public final boolean revokeIdentity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean doesKeyExist(Name keyName) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try (Cursor cursor = this.database_.rawQuery("SELECT count(*) FROM Key WHERE identity_name=? AND key_identifier=?", new String[]{identityName.toUri(), keyId});){
            if (cursor.moveToNext()) {
                boolean bl = cursor.getInt(0) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public final void addKey(Name keyName, KeyType keyType, Blob publicKeyDer) throws SecurityException {
        if (keyName.size() == 0) {
            return;
        }
        if (this.doesKeyExist(keyName)) {
            return;
        }
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        this.addIdentity(identityName);
        ContentValues values = new ContentValues();
        values.put("identity_name", identityName.toUri());
        values.put("key_identifier", keyId);
        values.put("key_type", Integer.valueOf(keyType.getNumericType()));
        values.put("public_key", publicKeyDer.getImmutableArray());
        if (this.database_.insert("Key", null, values) < 0L) {
            throw new SecurityException("AndroidSqlite3IdentityStorage.addKey: SQLite error for insert");
        }
    }

    @Override
    public final Blob getKey(Name keyName) throws SecurityException {
        if (keyName.size() == 0) {
            throw new SecurityException("AndroidSqlite3IdentityStorage.getKey: Empty keyName");
        }
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try (Cursor cursor = this.database_.rawQuery("SELECT public_key FROM Key WHERE identity_name=? AND key_identifier=?", new String[]{identityName.toUri(), keyId});){
            if (cursor.moveToNext()) {
                Blob blob = new Blob(cursor.getBlob(0));
                return blob;
            }
            throw new SecurityException("AndroidSqlite3IdentityStorage.getKey: The key does not exist");
        }
    }

    @Override
    protected void updateKeyStatus(Name keyName, boolean isActive) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        ContentValues values = new ContentValues();
        values.put("active", Integer.valueOf(isActive ? 1 : 0));
        this.database_.update("Key", values, "identity_name=? AND key_identifier=?", new String[]{identityName.toUri(), keyId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean doesCertificateExist(Name certificateName) throws SecurityException {
        try (Cursor cursor = this.database_.rawQuery("SELECT count(*) FROM Certificate WHERE cert_name=?", new String[]{certificateName.toUri()});){
            if (cursor.moveToNext()) {
                boolean bl = cursor.getInt(0) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public final void addCertificate(IdentityCertificate certificate) throws SecurityException {
        Name certificateName = certificate.getName();
        Name keyName = certificate.getPublicKeyName();
        this.addKey(keyName, certificate.getPublicKeyInfo().getKeyType(), certificate.getPublicKeyInfo().getKeyDer());
        if (this.doesCertificateExist(certificateName)) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("cert_name", certificateName.toUri());
        Name signerName = KeyLocator.getFromSignature(certificate.getSignature()).getKeyName();
        values.put("cert_issuer", signerName.toUri());
        String keyId = keyName.get(-1).toEscapedString();
        Name identity = keyName.getPrefix(-1);
        values.put("identity_name", identity.toUri());
        values.put("key_identifier", keyId);
        values.put("not_before", dateFormat_.format(new Timestamp((long)certificate.getNotBefore())));
        values.put("not_after", dateFormat_.format(new Timestamp((long)certificate.getNotAfter())));
        values.put("certificate_data", certificate.wireEncode().getImmutableArray());
        if (this.database_.insert("Certificate", null, values) < 0L) {
            throw new SecurityException("AndroidSqlite3IdentityStorage.addCertificate: SQLite error for insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IdentityCertificate getCertificate(Name certificateName) throws SecurityException {
        if (this.doesCertificateExist(certificateName)) {
            IdentityCertificate certificate;
            block7: {
                certificate = new IdentityCertificate();
                try (Cursor cursor = this.database_.rawQuery("SELECT certificate_data FROM Certificate WHERE cert_name=?", new String[]{certificateName.toUri()});){
                    if (cursor.moveToNext()) {
                        try {
                            certificate.wireDecode(new Blob(cursor.getBlob(0)));
                            break block7;
                        }
                        catch (EncodingException ex) {
                            throw new SecurityException("AndroidSqlite3IdentityStorage: Error decoding certificate data: " + ex);
                        }
                    }
                    throw new SecurityException("AndroidSqlite3IdentityStorage.getKey: The certificate does not exist");
                }
            }
            return certificate;
        }
        return new IdentityCertificate();
    }

    @Override
    public final String getTpmLocator() throws SecurityException {
        try (Cursor cursor = this.database_.rawQuery("SELECT tpm_locator FROM TpmInfo", null);){
            if (cursor.moveToNext()) {
                String string = cursor.getString(0);
                return string;
            }
            throw new SecurityException("AndroidSqlite3IdentityStorage.getTpmLocator: TPM info does not exist");
        }
    }

    @Override
    public final Name getDefaultIdentity() throws SecurityException {
        try (Cursor cursor = this.database_.rawQuery("SELECT identity_name FROM Identity WHERE default_identity=1", null);){
            if (cursor.moveToNext()) {
                Name name = new Name(cursor.getString(0));
                return name;
            }
            throw new SecurityException("AndroidSqlite3IdentityStorage.getDefaultIdentity: The default identity is not defined");
        }
    }

    @Override
    public final Name getDefaultKeyNameForIdentity(Name identityName) throws SecurityException {
        try (Cursor cursor = this.database_.rawQuery("SELECT key_identifier FROM Key WHERE identity_name=? AND default_key=1", new String[]{identityName.toUri()});){
            if (cursor.moveToNext()) {
                Name name = new Name(identityName).append(cursor.getString(0));
                return name;
            }
            throw new SecurityException("AndroidSqlite3IdentityStorage.getDefaultKeyNameForIdentity: The default key for the identity is not defined");
        }
    }

    @Override
    public final Name getDefaultCertificateNameForKey(Name keyName) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try (Cursor cursor = this.database_.rawQuery("SELECT cert_name FROM Certificate WHERE identity_name=? AND key_identifier=? AND default_cert=1", new String[]{identityName.toUri(), keyId});){
            if (cursor.moveToNext()) {
                Name name = new Name(cursor.getString(0));
                return name;
            }
            throw new SecurityException("AndroidSqlite3IdentityStorage.getDefaultCertificateNameForKey: The default certificate for the key name is not defined");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllIdentities(ArrayList nameList, boolean isDefault) throws SecurityException {
        String sql = isDefault ? "SELECT identity_name FROM Identity WHERE default_identity=1" : "SELECT identity_name FROM Identity WHERE default_identity=0";
        try (Cursor cursor = this.database_.rawQuery(sql, new String[0]);){
            while (cursor.moveToNext()) {
                nameList.add(new Name(cursor.getString(0)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllKeyNamesOfIdentity(Name identityName, ArrayList nameList, boolean isDefault) throws SecurityException {
        String sql = isDefault ? "SELECT key_identifier FROM Key WHERE default_key=1 and identity_name=?" : "SELECT key_identifier FROM Key WHERE default_key=0 and identity_name=?";
        try (Cursor cursor = this.database_.rawQuery(sql, new String[]{identityName.toUri()});){
            while (cursor.moveToNext()) {
                nameList.add(new Name(identityName).append(cursor.getString(0)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllCertificateNamesOfKey(Name keyName, ArrayList nameList, boolean isDefault) throws SecurityException {
        String sql = isDefault ? "SELECT cert_name FROM Certificate  WHERE default_cert=1 and identity_name=? and key_identifier=?" : "SELECT cert_name FROM Certificate  WHERE default_cert=0 and identity_name=? and key_identifier=?";
        try (Cursor cursor = this.database_.rawQuery(sql, new String[]{keyName.getPrefix(-1).toUri(), keyName.get(-1).toEscapedString()});){
            while (cursor.moveToNext()) {
                nameList.add(new Name(cursor.getString(0)));
            }
        }
    }

    @Override
    public final void setDefaultIdentity(Name identityName) throws SecurityException {
        ContentValues values = new ContentValues();
        values.put("default_identity", Integer.valueOf(0));
        this.database_.update("Identity", values, "default_identity=1", null);
        values = new ContentValues();
        values.put("default_identity", Integer.valueOf(1));
        this.database_.update("Identity", values, "identity_name=?", new String[]{identityName.toUri()});
    }

    @Override
    public final void setDefaultKeyNameForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        this.checkSetDefaultKeyNameForIdentity(keyName, identityNameCheck);
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        ContentValues values = new ContentValues();
        values.put("default_key", Integer.valueOf(0));
        this.database_.update("Key", values, "default_key=1 and identity_name=?", new String[]{identityName.toUri()});
        values = new ContentValues();
        values.put("default_key", Integer.valueOf(1));
        this.database_.update("Key", values, "identity_name=? AND key_identifier=?", new String[]{identityName.toUri(), keyId});
    }

    @Override
    public final void setDefaultCertificateNameForKey(Name keyName, Name certificateName) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        ContentValues values = new ContentValues();
        values.put("default_cert", Integer.valueOf(0));
        this.database_.update("Certificate", values, "default_cert=1 AND identity_name=? AND key_identifier=?", new String[]{identityName.toUri(), keyId});
        values = new ContentValues();
        values.put("default_cert", Integer.valueOf(1));
        this.database_.update("Certificate", values, "identity_name=? AND key_identifier=? AND cert_name=?", new String[]{identityName.toUri(), keyId, certificateName.toUri()});
    }

    @Override
    public void deleteCertificateInfo(Name certificateName) throws SecurityException {
        if (certificateName.size() == 0) {
            return;
        }
        this.database_.delete("Certificate", "cert_name=?", new String[]{certificateName.toUri()});
    }

    @Override
    public void deletePublicKeyInfo(Name keyName) throws SecurityException {
        if (keyName.size() == 0) {
            return;
        }
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        this.database_.delete("Certificate", "identity_name=? and key_identifier=?", new String[]{identityName.toUri(), keyId});
        this.database_.delete("Key", "identity_name=? and key_identifier=?", new String[]{identityName.toUri(), keyId});
    }

    @Override
    public void deleteIdentityInfo(Name identityName) throws SecurityException {
        String identity = identityName.toUri();
        this.database_.delete("Certificate", "identity_name=?", new String[]{identity});
        this.database_.delete("Key", "identity_name=?", new String[]{identity});
        this.database_.delete("Identity", "identity_name=?", new String[]{identity});
    }
}

