/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.certificate;

import net.named_data.jndn.encoding.OID;
import net.named_data.jndn.encoding.der.DerEncodingException;
import net.named_data.jndn.encoding.der.DerNode;
import net.named_data.jndn.util.Blob;

public class CertificateExtension {
    protected final OID extensionId_;
    protected final boolean isCritical_;
    protected final Blob extensionValue_;

    public CertificateExtension(String oid, boolean isCritical, Blob value) {
        this.extensionId_ = new OID(oid);
        this.isCritical_ = isCritical;
        this.extensionValue_ = value;
    }

    public CertificateExtension(OID oid, boolean isCritical, Blob value) {
        this.extensionId_ = oid;
        this.isCritical_ = isCritical;
        this.extensionValue_ = value;
    }

    public final DerNode toDer() throws DerEncodingException {
        DerNode.DerSequence root = new DerNode.DerSequence();
        DerNode.DerOid extensionId = new DerNode.DerOid(this.extensionId_);
        DerNode.DerBoolean isCritical = new DerNode.DerBoolean(this.isCritical_);
        DerNode.DerOctetString extensionValue = new DerNode.DerOctetString(this.extensionValue_.buf());
        root.addChild(extensionId);
        root.addChild(isCritical);
        root.addChild(extensionValue);
        root.getSize();
        return root;
    }

    public final Blob toDerBlob() throws DerEncodingException {
        return this.toDer().encode();
    }

    public final OID getOid() {
        return this.extensionId_;
    }

    public final boolean getIsCritical() {
        return this.isCritical_;
    }

    public final Blob getValue() {
        return this.extensionValue_;
    }
}

