/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import java.nio.ByteBuffer;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class CommandInterestSigner {
    public static final int POS_SIGNATURE_VALUE = -1;
    public static final int POS_SIGNATURE_INFO = -2;
    public static final int POS_NONCE = -3;
    public static final int POS_TIMESTAMP = -4;
    public static final int MINIMUM_SIZE = 4;
    private final KeyChain keyChain_;
    private double lastUsedTimestamp_;
    private final Object lastUsedTimestampLock_ = new Object();
    private double nowOffsetMilliseconds_ = 0.0;

    public CommandInterestSigner(KeyChain keyChain) {
        this.keyChain_ = keyChain;
        this.lastUsedTimestamp_ = Math.round(Common.getNowMilliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Interest makeCommandInterest(Name name, SigningInfo params, WireFormat wireFormat) throws PibImpl.Error, KeyChain.Error, TpmBackEnd.Error {
        double timestamp;
        Interest commandInterest = new Interest(name);
        Object object = this.lastUsedTimestampLock_;
        synchronized (object) {
            double now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_;
            for (timestamp = (double)Math.round(now); timestamp <= this.lastUsedTimestamp_; timestamp += 1.0) {
            }
            this.lastUsedTimestamp_ = timestamp;
        }
        TlvEncoder encoder = new TlvEncoder(8);
        encoder.writeNonNegativeInteger((long)timestamp);
        commandInterest.getName().append(new Blob(encoder.getOutput(), false));
        ByteBuffer randomBuffer = ByteBuffer.allocate(8);
        Common.getRandom().nextBytes(randomBuffer.array());
        commandInterest.getName().append(new Blob(randomBuffer, false));
        this.keyChain_.sign(commandInterest, params, wireFormat);
        return commandInterest;
    }

    public final Interest makeCommandInterest(Name name, SigningInfo params) throws PibImpl.Error, KeyChain.Error, TpmBackEnd.Error {
        return this.makeCommandInterest(name, params, WireFormat.getDefaultWireFormat());
    }

    public final Interest makeCommandInterest(Name name) throws PibImpl.Error, KeyChain.Error, TpmBackEnd.Error {
        return this.makeCommandInterest(name, new SigningInfo(), WireFormat.getDefaultWireFormat());
    }

    public final void setNowOffsetMilliseconds_(double nowOffsetMilliseconds) {
        this.nowOffsetMilliseconds_ = nowOffsetMilliseconds;
    }
}

