/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt.algo;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.named_data.jndn.encrypt.DecryptKey;
import net.named_data.jndn.encrypt.EncryptKey;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.tpm.TpmPrivateKey;
import net.named_data.jndn.util.Blob;

public class RsaAlgorithm {
    private static KeyFactory keyFactory_;

    public static DecryptKey generateKey(RsaKeyParams params) throws SecurityException {
        TpmPrivateKey privateKey;
        try {
            privateKey = TpmPrivateKey.generatePrivateKey(params);
        }
        catch (IllegalArgumentException ex) {
            throw new SecurityException("generateKey: Error in generatePrivateKey: " + ex);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("generateKey: Error in generatePrivateKey: " + ex);
        }
        try {
            return new DecryptKey(privateKey.toPkcs8());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("generateKey: Error in toPkcs8: " + ex);
        }
    }

    public static EncryptKey deriveEncryptKey(Blob keyBits) throws SecurityException {
        TpmPrivateKey privateKey = new TpmPrivateKey();
        try {
            privateKey.loadPkcs8(keyBits.buf());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("deriveEncryptKey: Error in loadPkcs8: " + ex);
        }
        try {
            return new EncryptKey(privateKey.derivePublicKey());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("deriveEncryptKey: Error in derivePublicKey: " + ex);
        }
    }

    public static Blob decrypt(Blob keyBits, Blob encryptedData, EncryptParams params) throws SecurityException {
        TpmPrivateKey privateKey = new TpmPrivateKey();
        try {
            privateKey.loadPkcs8(keyBits.buf());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("decrypt: Error in loadPkcs8: " + ex);
        }
        try {
            return privateKey.decrypt(encryptedData.buf(), params.getAlgorithmType());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("decrypt: Error in decrypt: " + ex);
        }
    }

    public static Blob encrypt(Blob keyBits, Blob plainData, EncryptParams params) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String transformation;
        PublicKey publicKey = keyFactory_.generatePublic(new X509EncodedKeySpec(keyBits.getImmutableArray()));
        if (params.getAlgorithmType() == EncryptAlgorithmType.RsaPkcs) {
            transformation = "RSA/ECB/PKCS1Padding";
        } else if (params.getAlgorithmType() == EncryptAlgorithmType.RsaOaep) {
            transformation = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
        } else {
            throw new Error("unsupported padding scheme");
        }
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, publicKey);
        return new Blob(cipher.doFinal(plainData.getImmutableArray()), false);
    }

    static {
        try {
            keyFactory_ = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(RsaAlgorithm.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

