/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import net.named_data.jndn.encrypt.ProducerDb;
import net.named_data.jndn.encrypt.Sqlite3ProducerDbBase;
import net.named_data.jndn.util.Blob;

public class AndroidSqlite3ProducerDb
extends Sqlite3ProducerDbBase {
    private final SQLiteDatabase database_;

    public AndroidSqlite3ProducerDb(String databaseFilePath) {
        this.database_ = SQLiteDatabase.openDatabase((String)databaseFilePath, null, (int)0x10000000);
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  contentkeys(                                     \n    rowId            INTEGER PRIMARY KEY,          \n    timeslot         INTEGER,                      \n    key              BLOB NOT NULL                 \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   timeslotIndex ON contentkeys(timeslot);         \n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasContentKey(double timeSlot) throws ProducerDb.Error {
        int fixedTimeSlot = AndroidSqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        try (Cursor cursor = this.database_.rawQuery("SELECT key FROM contentkeys where timeslot=?", new String[]{Integer.toString(fixedTimeSlot)});){
            if (cursor.moveToNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public Blob getContentKey(double timeSlot) throws ProducerDb.Error {
        int fixedTimeSlot = AndroidSqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        try (Cursor cursor = this.database_.rawQuery("SELECT key FROM contentkeys where timeslot=?", new String[]{Integer.toString(fixedTimeSlot)});){
            if (cursor.moveToNext()) {
                Blob blob = new Blob(cursor.getBlob(0));
                return blob;
            }
            throw new ProducerDb.Error("AndroidSqlite3ProducerDb.getContentKey: Cannot get the key from the database");
        }
    }

    @Override
    public void addContentKey(double timeSlot, Blob key) throws ProducerDb.Error {
        int fixedTimeSlot = AndroidSqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        ContentValues values = new ContentValues();
        values.put("timeslot", Integer.valueOf(fixedTimeSlot));
        values.put("key", key.getImmutableArray());
        if (this.database_.insert("contentkeys", null, values) < 0L) {
            throw new ProducerDb.Error("AndroidSqlite3ProducerDb.addContentKey: SQLite error");
        }
    }

    @Override
    public void deleteContentKey(double timeSlot) throws ProducerDb.Error {
        int fixedTimeSlot = AndroidSqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        this.database_.execSQL("DELETE FROM contentkeys WHERE timeslot=?", new Object[]{fixedTimeSlot});
    }
}

