/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding.der;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.named_data.jndn.encoding.OID;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerEncodingException;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.DynamicByteBuffer;

public class DerNode {
    protected DerStructure parent_ = null;
    private int nodeType_;
    protected ByteBuffer header_ = ByteBuffer.allocate(0);
    protected DynamicByteBuffer payload_ = new DynamicByteBuffer(0);

    private DerNode(int nodeType) {
        this.nodeType_ = nodeType;
    }

    public int getSize() {
        return this.header_.remaining() + this.payload_.position();
    }

    protected final void encodeHeader(int size) {
        DynamicByteBuffer buffer = new DynamicByteBuffer(10);
        buffer.ensuredPut((byte)this.nodeType_);
        if (size < 0) {
            throw new Error("encodeHeader: DER object has negative length");
        }
        if (size <= 127) {
            buffer.ensuredPut((byte)(size & 0xFF));
        } else {
            DynamicByteBuffer tempBuf = new DynamicByteBuffer(10);
            tempBuf.position(tempBuf.limit());
            int val = size;
            int n = 0;
            while (val != 0) {
                tempBuf.ensuredPutFromBack((byte)(val & 0xFF));
                val >>= 8;
                ++n;
            }
            tempBuf.ensuredPutFromBack((byte)((0x80 | n) & 0xFF));
            buffer.ensuredPut(tempBuf.buffer());
        }
        this.header_ = buffer.flippedBuffer();
    }

    protected final int decodeHeader(ByteBuffer inputBuf, int startIdx) throws DerDecodingException {
        boolean isLongFormat;
        int idx = startIdx;
        int nodeType = inputBuf.get(idx) & 0xFF;
        this.nodeType_ = nodeType;
        int sizeLen = inputBuf.get(++idx) & 0xFF;
        ++idx;
        DynamicByteBuffer header = new DynamicByteBuffer(10);
        header.ensuredPut((byte)nodeType);
        header.ensuredPut((byte)sizeLen);
        int size = sizeLen;
        boolean bl = isLongFormat = (sizeLen & 0x80) != 0;
        if (isLongFormat) {
            size = 0;
            for (int lenCount = sizeLen & 0x7F; lenCount > 0; --lenCount) {
                if (inputBuf.limit() <= idx) {
                    throw new DerDecodingException("DerNode.parse: The input length is too small");
                }
                byte b = inputBuf.get(idx);
                ++idx;
                header.ensuredPut(b);
                size = 256 * size + (b & 0xFF);
            }
        }
        this.header_ = header.flippedBuffer();
        return size;
    }

    public Blob encode() {
        DynamicByteBuffer buffer = new DynamicByteBuffer(this.getSize());
        buffer.ensuredPut(this.header_);
        buffer.ensuredPut(this.payload_.flippedBuffer());
        return new Blob(buffer.flippedBuffer(), false);
    }

    protected void decode(ByteBuffer inputBuf, int startIdx) throws DerDecodingException {
        int idx = startIdx;
        int payloadSize = this.decodeHeader(inputBuf, idx);
        int skipBytes = this.header_.remaining();
        if (payloadSize > 0) {
            this.payload_.ensuredPut(inputBuf, idx += skipBytes, idx + payloadSize);
        }
    }

    public static DerNode parse(ByteBuffer inputBuf, int startIdx) throws DerDecodingException {
        DerNode newNode;
        if (inputBuf.limit() <= startIdx) {
            throw new DerDecodingException("DerNode.parse: The input length is too small");
        }
        int nodeType = inputBuf.get(startIdx) & 0xFF;
        if (nodeType == 1) {
            newNode = new DerBoolean();
        } else if (nodeType == 2) {
            newNode = new DerInteger();
        } else if (nodeType == 3) {
            newNode = new DerBitString();
        } else if (nodeType == 4) {
            newNode = new DerOctetString();
        } else if (nodeType == 5) {
            newNode = new DerNull();
        } else if (nodeType == 6) {
            newNode = new DerOid();
        } else if (nodeType == 48) {
            newNode = new DerSequence();
        } else if (nodeType == 19) {
            newNode = new DerPrintableString();
        } else if (nodeType == 24) {
            newNode = new DerGeneralizedTime();
        } else if ((nodeType & 0xE0) == 160) {
            newNode = new DerExplicitlyTagged(nodeType & 0x1F);
        } else {
            throw new DerDecodingException("Unimplemented DER type " + nodeType);
        }
        newNode.decode(inputBuf, startIdx);
        return newNode;
    }

    public static DerNode parse(ByteBuffer inputBuf) throws DerDecodingException {
        return DerNode.parse(inputBuf, inputBuf.position());
    }

    public Object toVal() throws DerDecodingException {
        return this.encode();
    }

    public final Blob getPayload() {
        return new Blob(this.payload_.flippedBuffer(), true);
    }

    public List getChildren() throws DerDecodingException {
        throw new DerDecodingException("getChildren: This DerNode is not DerSequence");
    }

    public static DerSequence getSequence(List children, int index) throws DerDecodingException {
        if (index < 0 || index >= children.size()) {
            throw new DerDecodingException("getSequence: Child index is out of bounds");
        }
        if (!(children.get(index) instanceof DerSequence)) {
            throw new DerDecodingException("getSequence: Child DerNode is not DerSequence");
        }
        return (DerSequence)children.get(index);
    }

    public static class DerExplicitlyTagged
    extends DerNode {
        private final int tagNumber_;
        private DerNode innerNode_ = null;

        public DerExplicitlyTagged(int tagNumber) {
            super(160);
            this.tagNumber_ = tagNumber;
        }

        @Override
        public Blob encode() {
            throw new UnsupportedOperationException("DerExplicitlyTagged.encode is not implemented");
        }

        @Override
        protected void decode(ByteBuffer inputBuf, int startIdx) throws DerDecodingException {
            super.decode(inputBuf, startIdx);
            this.innerNode_ = DerExplicitlyTagged.parse(this.getPayload().buf());
        }

        public final int getTagNumber() {
            return this.tagNumber_;
        }

        public final DerNode getInnerNode() {
            return this.innerNode_;
        }
    }

    public static class DerGeneralizedTime
    extends DerNode {
        private static final SimpleDateFormat dateFormat_ = DerGeneralizedTime.getDateFormat();

        public DerGeneralizedTime(double msSince1970) {
            super(24);
            String derTime = DerGeneralizedTime.toDerTimeString(msSince1970);
            this.payload_.ensuredPut(new Blob(derTime).buf());
            this.encodeHeader(this.payload_.position());
        }

        private DerGeneralizedTime() {
            super(24);
        }

        private static String toDerTimeString(double msSince1970) {
            Date utcTime = Common.millisecondsSince1970ToDate(Math.round(msSince1970));
            return dateFormat_.format(utcTime);
        }

        private static SimpleDateFormat getDateFormat() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }

        @Override
        public Object toVal() throws DerDecodingException {
            String timeStr = "" + new Blob(this.payload_.flippedBuffer(), false);
            try {
                Date date = dateFormat_.parse(timeStr);
                return (double)Common.dateToMillisecondsSince1970(date);
            }
            catch (ParseException ex) {
                throw new DerDecodingException("DerGeneralizedTime: Error decoding the date string: " + ex);
            }
        }
    }

    public static class DerPrintableString
    extends DerByteString {
        public DerPrintableString(ByteBuffer inputData) {
            super(inputData, 19);
        }

        private DerPrintableString() {
            super(null, 19);
        }
    }

    public static class DerSequence
    extends DerStructure {
        public DerSequence() {
            super(48);
        }
    }

    public static class DerOid
    extends DerNode {
        public DerOid(String oidStr) throws DerEncodingException {
            super(6);
            String[] splitString = oidStr.split("\\.");
            int[] parts = new int[splitString.length];
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = Integer.parseInt(splitString[i]);
            }
            this.prepareEncoding(parts);
        }

        public DerOid(OID oid) throws DerEncodingException {
            super(6);
            this.prepareEncoding(oid.getIntegerList());
        }

        private DerOid() {
            super(6);
        }

        private void prepareEncoding(int[] value) throws DerEncodingException {
            int firstNumber = 0;
            if (value.length == 0) {
                throw new DerEncodingException("No integer in OID");
            }
            if (value[0] < 0 || value[0] > 2) {
                throw new DerEncodingException("First integer in OID is out of range");
            }
            firstNumber = value[0] * 40;
            if (value.length >= 2) {
                if (value[1] >= 0 && value[1] <= 39) {
                    firstNumber += value[1];
                } else {
                    throw new DerEncodingException("Second integer in OID is out of range");
                }
            }
            DynamicByteBuffer encodedBuffer = new DynamicByteBuffer(10);
            encodedBuffer.ensuredPut(DerOid.encode128(firstNumber));
            if (value.length > 2) {
                for (int i = 2; i < value.length; ++i) {
                    encodedBuffer.ensuredPut(DerOid.encode128(value[i]));
                }
            }
            this.encodeHeader(encodedBuffer.position());
            this.payload_.ensuredPut(encodedBuffer.flippedBuffer());
        }

        private static ByteBuffer encode128(int value) {
            int mask = 127;
            DynamicByteBuffer outBytes = new DynamicByteBuffer(10);
            outBytes.position(outBytes.limit());
            if (value < 128) {
                outBytes.ensuredPutFromBack((byte)(value & mask));
            } else {
                outBytes.ensuredPutFromBack((byte)(value & mask));
                value >>= 7;
                while (value != 0) {
                    outBytes.ensuredPutFromBack((byte)(value & mask | 0x80));
                    value >>= 7;
                }
            }
            return outBytes.buffer().slice();
        }

        private int decode128(int offset, int[] skip) {
            int flagMask = 128;
            int result = 0;
            int oldOffset = offset;
            while ((this.payload_.buffer().get(offset) & flagMask) != 0) {
                result = 128 * result + (this.payload_.buffer().get(offset) & 0xFF) - 128;
                ++offset;
            }
            result = result * 128 + (this.payload_.buffer().get(offset) & 0xFF);
            skip[0] = offset - oldOffset + 1;
            return result;
        }

        @Override
        public Object toVal() throws DerDecodingException {
            int[] skip;
            ArrayList<Integer> components = new ArrayList<Integer>();
            for (int offset = 0; offset < this.payload_.position(); offset += skip[0]) {
                skip = new int[1];
                int nextVal = this.decode128(offset, skip);
                components.add(nextVal);
            }
            int firstByte = (Integer)components.get(0);
            int firstDigit = firstByte / 40;
            int secondDigit = firstByte % 40;
            String result = firstDigit + "." + secondDigit;
            for (int i = 1; i < components.size(); ++i) {
                result = result + "." + (Integer)components.get(i);
            }
            return result;
        }
    }

    public static class DerNull
    extends DerNode {
        public DerNull() {
            super(5);
            this.encodeHeader(0);
        }
    }

    public static class DerOctetString
    extends DerByteString {
        public DerOctetString(ByteBuffer inputData) {
            super(inputData, 4);
        }

        private DerOctetString() {
            super(null, 4);
        }
    }

    public static class DerBitString
    extends DerNode {
        public DerBitString(ByteBuffer inputBuf, int paddingLen) {
            super(3);
            if (inputBuf != null) {
                this.payload_.ensuredPut((byte)(paddingLen & 0xFF));
                this.payload_.ensuredPut(inputBuf);
                this.encodeHeader(this.payload_.position());
            }
        }

        private DerBitString() {
            super(3);
        }
    }

    public static class DerInteger
    extends DerNode {
        public DerInteger(int integer) throws DerEncodingException {
            super(2);
            if (integer < 0) {
                throw new DerEncodingException("DerInteger: Negative integers are not currently supported");
            }
            DynamicByteBuffer temp = new DynamicByteBuffer(10);
            temp.position(temp.limit());
            do {
                temp.ensuredPutFromBack((byte)(integer & 0xFF));
            } while ((integer >>= 8) > 0);
            if ((temp.buffer().get(temp.position()) & 0xFF) >= 128) {
                temp.ensuredPutFromBack((byte)0);
            }
            this.payload_.ensuredPut(temp.buffer().slice());
            this.encodeHeader(this.payload_.position());
        }

        public DerInteger(ByteBuffer buffer) throws DerEncodingException {
            super(2);
            if (buffer.remaining() > 0 && (buffer.get(buffer.position()) & 0xFF) >= 128) {
                throw new DerEncodingException("DerInteger: Negative integers are not currently supported");
            }
            if (buffer.remaining() == 0) {
                this.payload_.ensuredPut((byte)0);
            } else {
                this.payload_.ensuredPut(buffer);
            }
            this.encodeHeader(this.payload_.position());
        }

        public DerInteger() {
            super(2);
        }

        @Override
        public Object toVal() throws DerDecodingException {
            if (this.payload_.buffer().position() > 0 && (this.payload_.buffer().get(0) & 0xFF) >= 128) {
                throw new DerDecodingException("DerInteger: Negative integers are not currently supported");
            }
            int result = 0;
            for (int i = 0; i < this.payload_.buffer().position(); ++i) {
                result <<= 8;
                result += this.payload_.buffer().get(i) & 0xFF;
            }
            return result;
        }
    }

    public static class DerBoolean
    extends DerNode {
        public DerBoolean(boolean value) {
            super(1);
            byte val = value ? (byte)-1 : 0;
            this.payload_.ensuredPut(val);
            this.encodeHeader(1);
        }

        private DerBoolean() {
            super(1);
        }

        @Override
        public Object toVal() throws DerDecodingException {
            byte val = this.payload_.buffer().get(0);
            return val != 0;
        }
    }

    public static class DerByteString
    extends DerNode {
        private DerByteString(ByteBuffer inputData, int nodeType) {
            super(nodeType);
            if (inputData != null) {
                this.payload_.ensuredPut(inputData);
                this.encodeHeader(inputData.remaining());
            }
        }

        @Override
        public Object toVal() throws DerDecodingException {
            return this.getPayload();
        }
    }

    public static class DerStructure
    extends DerNode {
        private boolean childChanged_ = false;
        private final ArrayList<DerNode> nodeList_ = new ArrayList();
        private int size_ = 0;

        private DerStructure(int nodeType) {
            super(nodeType);
        }

        @Override
        public int getSize() {
            if (this.childChanged_) {
                this.updateSize();
                this.childChanged_ = false;
            }
            this.encodeHeader(this.size_);
            return this.size_ + this.header_.remaining();
        }

        @Override
        public final List getChildren() {
            return this.nodeList_;
        }

        private void updateSize() {
            int newSize = 0;
            for (int i = 0; i < this.nodeList_.size(); ++i) {
                DerNode n = this.nodeList_.get(i);
                newSize += n.getSize();
            }
            this.size_ = newSize;
            this.childChanged_ = false;
        }

        public final void addChild(DerNode node, boolean notifyParent) {
            node.parent_ = this;
            this.nodeList_.add(node);
            if (notifyParent && this.parent_ != null) {
                this.parent_.setChildChanged();
            }
            this.childChanged_ = true;
        }

        public final void addChild(DerNode node) {
            this.addChild(node, false);
        }

        private void setChildChanged() {
            if (this.parent_ != null) {
                this.parent_.setChildChanged();
            }
            this.childChanged_ = true;
        }

        @Override
        public Blob encode() {
            DynamicByteBuffer temp = new DynamicByteBuffer(10);
            this.updateSize();
            this.encodeHeader(this.size_);
            temp.ensuredPut(this.header_);
            for (int i = 0; i < this.nodeList_.size(); ++i) {
                DerNode n = this.nodeList_.get(i);
                Blob encodedChild = n.encode();
                temp.ensuredPut(encodedChild.buf());
            }
            return new Blob(temp.flippedBuffer(), false);
        }

        @Override
        protected void decode(ByteBuffer inputBuf, int startIdx) throws DerDecodingException {
            int size;
            int idx = startIdx;
            this.size_ = this.decodeHeader(inputBuf, idx);
            idx += this.header_.remaining();
            for (int accSize = 0; accSize < this.size_; accSize += size) {
                DerNode node = DerStructure.parse(inputBuf, idx);
                size = node.getSize();
                idx += size;
                this.addChild(node, false);
            }
        }
    }
}

