/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.util.Blob;

public class ProtobufTlv {
    public static Blob encode(Message message) {
        if (!message.isInitialized()) {
            throw new Error("Message fields are not initialized: " + message.getInitializationErrorString());
        }
        TlvEncoder encoder = new TlvEncoder(256);
        ProtobufTlv.encodeMessageValue(message, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    public static void decode(Message.Builder message, ByteBuffer input) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        ProtobufTlv.decodeMessageValue(message, decoder, input.remaining());
    }

    public static void decode(Message.Builder message, Blob input) throws EncodingException {
        ProtobufTlv.decode(message, input.buf());
    }

    public static Name toName(Message nameMessage) {
        Name name = new Name();
        Descriptors.Descriptor descriptor = nameMessage.getDescriptorForType();
        Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)descriptor.getFields().get(0);
        for (int i = 0; i < nameMessage.getRepeatedFieldCount(field); ++i) {
            name.append(new Blob(((ByteString)nameMessage.getRepeatedField(field, i)).asReadOnlyByteBuffer(), true));
        }
        return name;
    }

    private static void encodeMessageValue(Message message, TlvEncoder encoder) {
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        List fields = descriptor.getFields();
        for (int i = fields.size() - 1; i >= 0; --i) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)fields.get(i);
            int tlvType = field.getNumber();
            int valueCount = 0;
            if (field.isRepeated()) {
                valueCount = message.getRepeatedFieldCount(field);
            } else if (message.hasField(field)) {
                valueCount = 1;
            }
            for (int iValue = valueCount - 1; iValue >= 0; --iValue) {
                Object value = field.isRepeated() ? message.getRepeatedField(field, iValue) : message.getField(field);
                if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    int saveLength = encoder.getLength();
                    ProtobufTlv.encodeMessageValue((Message)value, encoder);
                    encoder.writeTypeAndLength(tlvType, encoder.getLength() - saveLength);
                    continue;
                }
                if (field.getType() == Descriptors.FieldDescriptor.Type.UINT32) {
                    encoder.writeNonNegativeIntegerTlv(tlvType, ((Integer)value).intValue());
                    continue;
                }
                if (field.getType() == Descriptors.FieldDescriptor.Type.UINT64) {
                    encoder.writeNonNegativeIntegerTlv(tlvType, (Long)value);
                    continue;
                }
                if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                    int intValue = ((Descriptors.EnumValueDescriptor)value).getNumber();
                    if (intValue < 0) {
                        throw new Error("ProtobufTlv.encode: ENUM value may not be negative");
                    }
                    encoder.writeNonNegativeIntegerTlv(tlvType, intValue);
                    continue;
                }
                if (field.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                    encoder.writeBlobTlv(tlvType, ((ByteString)value).asReadOnlyByteBuffer());
                    continue;
                }
                if (field.getType() == Descriptors.FieldDescriptor.Type.STRING) {
                    encoder.writeBlobTlv(tlvType, new Blob((String)value).buf());
                    continue;
                }
                if (field.getType() == Descriptors.FieldDescriptor.Type.BOOL) {
                    if (!((Boolean)value).booleanValue()) continue;
                    encoder.writeTypeAndLength(tlvType, 0);
                    continue;
                }
                throw new Error("ProtobufTlv.encode: Unknown field type");
            }
        }
    }

    private static void decodeMessageValue(Message.Builder message, TlvDecoder decoder, int endOffset) throws EncodingException {
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            int innerEndOffset;
            Message.Builder innerMessage;
            int tlvType = field.getNumber();
            if (field.isOptional() && !decoder.peekType(tlvType, endOffset)) continue;
            if (field.isRepeated()) {
                while (decoder.peekType(tlvType, endOffset)) {
                    if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                        innerMessage = message.newBuilderForField(field);
                        innerEndOffset = decoder.readNestedTlvsStart(tlvType);
                        ProtobufTlv.decodeMessageValue(innerMessage, decoder, innerEndOffset);
                        decoder.finishNestedTlvs(innerEndOffset);
                        message.addRepeatedField(field, (Object)innerMessage.build());
                        continue;
                    }
                    message.addRepeatedField(field, ProtobufTlv.decodeFieldValue(field, tlvType, decoder, endOffset));
                }
                continue;
            }
            if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                innerMessage = message.newBuilderForField(field);
                innerEndOffset = decoder.readNestedTlvsStart(tlvType);
                ProtobufTlv.decodeMessageValue(innerMessage, decoder, innerEndOffset);
                decoder.finishNestedTlvs(innerEndOffset);
                message.setField(field, (Object)innerMessage.build());
                continue;
            }
            message.setField(field, ProtobufTlv.decodeFieldValue(field, tlvType, decoder, endOffset));
        }
    }

    private static Object decodeFieldValue(Descriptors.FieldDescriptor field, int tlvType, TlvDecoder decoder, int endOffset) throws EncodingException {
        if (field.getType() == Descriptors.FieldDescriptor.Type.UINT32) {
            return (int)decoder.readNonNegativeIntegerTlv(tlvType);
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.UINT64) {
            return decoder.readNonNegativeIntegerTlv(tlvType);
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            return field.getEnumType().findValueByNumber((int)decoder.readNonNegativeIntegerTlv(tlvType));
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
            return ByteString.copyFrom((ByteBuffer)decoder.readBlobTlv(tlvType));
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.STRING) {
            try {
                ByteBuffer byteBuffer = decoder.readBlobTlv(tlvType);
                return new String(new Blob(byteBuffer, false).getImmutableArray(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("UTF-8 decoder not supported: " + ex.getMessage());
            }
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.BOOL) {
            return decoder.readBooleanTlv(tlvType, endOffset);
        }
        throw new Error("ProtobufTlv.decode: Unknown field type");
    }
}

