/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.lp.LpPacket;

public class NetworkNack {
    private Reason reason_ = Reason.NONE;
    private int otherReasonCode_ = -1;

    public Reason getReason() {
        return this.reason_;
    }

    public int getOtherReasonCode() {
        return this.otherReasonCode_;
    }

    public void setReason(Reason reason) {
        this.reason_ = reason;
    }

    public void setOtherReasonCode(int otherReasonCode) {
        if (otherReasonCode < 0) {
            throw new Error("NetworkNack other reason code must be non-negative");
        }
        this.otherReasonCode_ = otherReasonCode;
    }

    public static NetworkNack getFirstHeader(LpPacket lpPacket) {
        for (int i = 0; i < lpPacket.countHeaderFields(); ++i) {
            Object field = lpPacket.getHeaderField(i);
            if (!(field instanceof NetworkNack)) continue;
            return (NetworkNack)field;
        }
        return null;
    }

    public static enum Reason {
        NONE(0),
        CONGESTION(50),
        DUPLICATE(100),
        NO_ROUTE(150),
        OTHER_CODE(Short.MAX_VALUE);

        private final int type_;

        private Reason(int type) {
            this.type_ = type;
        }

        public final int getNumericType() {
            return this.type_;
        }
    }
}

