/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.HmacWithSha256Signature;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;
import net.named_data.jndn.util.ChangeCounter;

public class KeyLocator
implements ChangeCountable {
    private KeyLocatorType type_ = KeyLocatorType.NONE;
    private Blob keyData_ = new Blob();
    private final ChangeCounter keyName_ = new ChangeCounter(new Name());
    private long changeCount_ = 0L;

    public KeyLocator() {
    }

    public KeyLocator(KeyLocator keyLocator) {
        this.type_ = keyLocator.type_;
        this.keyData_ = keyLocator.keyData_;
        this.keyName_.set(new Name(keyLocator.getKeyName()));
    }

    public final KeyLocatorType getType() {
        return this.type_;
    }

    public final Blob getKeyData() {
        return this.keyData_;
    }

    public final Name getKeyName() {
        return (Name)this.keyName_.get();
    }

    public final void setType(KeyLocatorType type) {
        this.type_ = type;
        ++this.changeCount_;
    }

    public final void setKeyData(Blob keyData) {
        this.keyData_ = keyData == null ? new Blob() : keyData;
        ++this.changeCount_;
    }

    public final void setKeyName(Name keyName) {
        this.keyName_.set(keyName == null ? new Name() : new Name(keyName));
        ++this.changeCount_;
    }

    public final void clear() {
        this.type_ = KeyLocatorType.NONE;
        this.keyData_ = new Blob();
        this.keyName_.set(new Name());
        ++this.changeCount_;
    }

    public boolean equals(KeyLocator other) {
        if (this.type_ != other.type_) {
            return false;
        }
        return !(this.type_ == KeyLocatorType.KEYNAME ? !this.getKeyName().equals(other.getKeyName()) : this.type_ == KeyLocatorType.KEY_LOCATOR_DIGEST && !this.getKeyData().equals(other.getKeyData()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof KeyLocator)) {
            return false;
        }
        return this.equals((KeyLocator)other);
    }

    public static boolean canGetFromSignature(Signature signature) {
        return signature instanceof Sha256WithRsaSignature || signature instanceof Sha256WithEcdsaSignature || signature instanceof HmacWithSha256Signature;
    }

    public static KeyLocator getFromSignature(Signature signature) {
        if (signature instanceof Sha256WithRsaSignature) {
            return ((Sha256WithRsaSignature)signature).getKeyLocator();
        }
        if (signature instanceof Sha256WithEcdsaSignature) {
            return ((Sha256WithEcdsaSignature)signature).getKeyLocator();
        }
        if (signature instanceof HmacWithSha256Signature) {
            return ((HmacWithSha256Signature)signature).getKeyLocator();
        }
        throw new Error("KeyLocator.getFromSignature: Signature type does not have a KeyLocator");
    }

    @Override
    public final long getChangeCount() {
        if (this.keyName_.checkChanged()) {
            ++this.changeCount_;
        }
        return this.changeCount_;
    }
}

