/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties.web;

import jakarta.servlet.ServletContext;
import java.util.Properties;
import net.n2oapp.properties.ReloadableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;

public class ServletPathProperties
extends ReloadableProperties
implements ServletContextAware {
    private static Logger log = LoggerFactory.getLogger(ServletPathProperties.class);
    private String propertyName;

    public ServletPathProperties() {
    }

    public ServletPathProperties(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    public ServletPathProperties(ServletContext servletContext, Properties baseProperties) {
        this.setServletContext(servletContext);
        this.setBaseProperties(baseProperties);
    }

    public void setServletContext(ServletContext servletContext) {
        this.propertyName = ServletPathProperties.calcServletPropertiesPath(servletContext);
        this.setResource((Resource)new ClassPathResource(this.propertyName));
    }

    public void setClasspathPackage(String packageName) {
        if (this.propertyName == null) {
            throw new IllegalStateException("Servlet context does not set");
        }
        this.setResource((Resource)new ClassPathResource(packageName + "/" + this.propertyName));
    }

    public void setFilesystemFolder(String folderName) {
        if (this.propertyName == null) {
            throw new IllegalStateException("Servlet context does not set");
        }
        this.setResource((Resource)new FileSystemResource(folderName + "/" + this.propertyName));
    }

    private static String calcServletPropertiesPath(ServletContext servletContext) {
        String context = servletContext.getContextPath().replace("/", "").replace("\\", "");
        if (context.isEmpty()) {
            context = "root";
        }
        return context + ".properties";
    }
}

