/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties.web;

import jakarta.servlet.ServletContext;
import java.util.Properties;
import net.n2oapp.properties.ExpressionBasedProperties;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.ReloadableProperties;
import net.n2oapp.properties.reader.PropertiesReader;
import net.n2oapp.properties.web.ServletPathProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.context.ServletContextAware;

public class WebApplicationProperties
extends ExpressionBasedProperties
implements ServletContextAware {
    private String buildPropertiesName;

    public WebApplicationProperties(String defaultPropertiesName, String buildPropertiesName) {
        this.buildPropertiesName = buildPropertiesName;
        OverrideProperties buildProperties = PropertiesReader.getPropertiesFromClasspath(buildPropertiesName, defaultPropertiesName);
        this.setBaseProperties(buildProperties);
    }

    public void setFilesystemFolder(String folderName) {
        ServletPathProperties servletPathProperties = (ServletPathProperties)this.getServletProperties();
        if (servletPathProperties != null) {
            servletPathProperties.setFilesystemFolder(folderName);
            servletPathProperties.setResource((Resource)new FileSystemResource(folderName + "/" + this.buildPropertiesName));
        }
    }

    public void setEnvironment(ConfigurableEnvironment webAppEnvironment) {
        this.setEvaluationContext((EvaluationContext)new StandardEvaluationContext((Object)webAppEnvironment));
    }

    public void setServletContext(ServletContext servletContext) {
        ServletPathProperties servletPathProperties = new ServletPathProperties(servletContext, this.getBaseProperties());
        this.setBaseProperties(servletPathProperties);
    }

    public ReloadableProperties getServletProperties() {
        Properties properties = this.getBaseProperties();
        if (properties instanceof ServletPathProperties) {
            ServletPathProperties servletPathProperties = (ServletPathProperties)properties;
            return servletPathProperties;
        }
        return null;
    }
}

