/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.Semaphore;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.io.PropertiesRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ReloadableProperties
extends OverrideProperties {
    private volatile long timeStamp = Long.MIN_VALUE;
    private volatile int cacheTime = 60;
    private volatile boolean exists;
    private volatile Resource resource;
    private final Semaphore available = new Semaphore(1);
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ReloadableProperties(URI uri) throws MalformedURLException {
        this.resource = new UrlResource(uri);
    }

    public ReloadableProperties(Resource resource) {
        this.resource = resource;
    }

    public ReloadableProperties() {
    }

    @Override
    public Set<String> stringPropertyNames() {
        this.refresh();
        return super.stringPropertyNames();
    }

    @Override
    public Enumeration<?> propertyNames() {
        this.refresh();
        return super.propertyNames();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        this.refresh();
        return super.keys();
    }

    @Override
    public String superGetProperty(String key) {
        Object oval = this.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    @Override
    public synchronized Object get(Object key) {
        this.refresh();
        return super.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.refresh();
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.refresh();
        return super.remove(key);
    }

    @Override
    public String getCurrentLvlProperty(String key) {
        this.refresh();
        return super.getCurrentLvlProperty(key);
    }

    private void refresh() {
        if (this.isExpired()) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() {
        if (this.resource == null) {
            return;
        }
        if (this.isExpired()) {
            this.clear();
        }
        try (InputStream resourceAsStream = this.resource.getInputStream();){
            this.available.acquire();
            this.load(resourceAsStream);
            this.exists = true;
        }
        catch (Exception e) {
            this.timeStamp = System.currentTimeMillis();
            this.exists = false;
            this.logger.debug(String.format("error while trying reload properties from [%s]", this.resource.toString()));
        }
        finally {
            this.available.release();
        }
    }

    public void updateProperty(Object key, Object value) {
        try {
            this.available.acquire();
            this.put(key, value);
            PropertiesRewriter.updateProperty(this.resource, key, value);
        }
        catch (IOException | InterruptedException e) {
            this.exists = false;
            if (key == null) {
                key = "null";
            }
            if (value == null) {
                value = "null";
            }
            this.logger.debug(String.format("error while trying update property (key: %s, value: %s) from [%s]", key.toString(), value.toString(), this.resource.toString()));
            throw new IllegalStateException(e);
        }
        finally {
            this.available.release();
        }
    }

    public void removeProperty(Object key) {
        try {
            this.available.acquire();
            if (this.containsKey(key)) {
                this.remove(key);
                PropertiesRewriter.removeProperty(this.resource, key);
            }
        }
        catch (IOException | InterruptedException e) {
            this.exists = false;
            if (key == null) {
                key = "null";
            }
            this.logger.debug(String.format("error while trying remove property (key: %s) from [%s]", key.toString(), this.resource.toString()));
            throw new IllegalStateException(e);
        }
        finally {
            this.available.release();
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isExpired() {
        long cacheTimeLong = this.cacheTime * 1000;
        long currentTime = System.currentTimeMillis();
        return this.timeStamp + cacheTimeLong < currentTime;
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        this.timeStamp = System.currentTimeMillis();
        super.load(reader);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        this.timeStamp = System.currentTimeMillis();
        super.load(inStream);
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException {
        this.timeStamp = System.currentTimeMillis();
        super.loadFromXML(in);
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(int cacheTime) {
        this.cacheTime = cacheTime;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

