/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties;

import java.util.Properties;
import net.n2oapp.properties.OverrideProperties;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionBasedProperties
extends OverrideProperties {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ParserContext PARSER_CONTEXT = new ParserContext(){

        public boolean isTemplate() {
            return true;
        }

        public String getExpressionPrefix() {
            return "#{";
        }

        public String getExpressionSuffix() {
            return "}";
        }
    };
    private EvaluationContext evaluationContext = new StandardEvaluationContext((Object)new StandardEnvironment());

    public ExpressionBasedProperties(Properties baseProperties) {
        super(baseProperties);
    }

    public ExpressionBasedProperties() {
    }

    public void setEvaluationContext(EvaluationContext context) {
        this.evaluationContext = context;
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        return this.extractExpression(value);
    }

    @Override
    public synchronized Object get(Object key) {
        Object value = super.get(key);
        if (value instanceof String) {
            value = this.extractExpression(value.toString());
        }
        return value;
    }

    private String extractExpression(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int idxStart = value.indexOf("#{");
        if (idxStart == -1) {
            return value;
        }
        String value1 = null;
        try {
            value1 = (String)EXPRESSION_PARSER.parseExpression(value, PARSER_CONTEXT).getValue(this.evaluationContext, String.class);
        }
        catch (EvaluationException e) {
            throw new IllegalStateException("Error evaluating expression " + value, e);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Error parsing expression " + value, e);
        }
        return value1 == null ? "" : value1;
    }
}

