/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.test.autoconfigure;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Configuration
public class TestcontainersPgAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TestcontainersPgAutoConfiguration.class);
    private static final String USERNAME = "postgres";
    private static final String PASSWORD = "postgres";
    private static final int PSQL_PORT = 5432;
    private static final WaitStrategy PG_WAIT_STRATEGY = new LogMessageWaitStrategy().withRegEx(".*database system is ready to accept connections.*\\s").withTimes(2).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
    private static int testcontainersPgImageVersion;

    @Value(value="${testcontainers.pg.version:12}")
    public void setEnv(int version) {
        testcontainersPgImageVersion = version;
    }

    @Bean
    public static TestcontainersPgDataSourceBeanFactoryPostProcessor testcontainersPgDataSourceBeanFactoryPostProcessor() {
        return new TestcontainersPgDataSourceBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="test", name={"testcontainers-pg"}, havingValue="true")
    public DataSource dataSource() {
        return new TestcontainersPgDataSourceFactory(TestcontainersPgAutoConfiguration.psqlContainer(), "postgres", "postgres").getTestcontainersPgDatabase();
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="test", name={"testcontainers-pg"}, havingValue="true")
    static GenericContainer psqlContainer() {
        GenericContainer gc = new GenericContainer(DockerImageName.parse((String)TestcontainersPgAutoConfiguration.generatePgImageName())).withEnv("POSTGRES_USER", "postgres").withEnv("POSTGRES_PASSWORD", "postgres").withExposedPorts(new Integer[]{5432});
        gc.setWaitStrategy(PG_WAIT_STRATEGY);
        return gc;
    }

    private static final String generatePgImageName() {
        if (testcontainersPgImageVersion >= 10 && testcontainersPgImageVersion <= 12) {
            return "inovus/postgres:" + testcontainersPgImageVersion + "-textsearch-ru";
        }
        return "inovus/postgres:12-textsearch-ru";
    }

    private static class TestcontainersPgDataSourceFactory {
        private final GenericContainer pg;
        private final String username;
        private final String password;
        private final int psqlPort = 5432;

        public TestcontainersPgDataSourceFactory(GenericContainer pg, String username, String password) {
            this.pg = pg;
            this.username = username;
            this.password = password;
        }

        DataSource getTestcontainersPgDatabase() {
            try {
                this.pg.start();
            }
            catch (Exception e) {
                logger.error("cannot build testcontainers PG", (Throwable)e);
                throw new BeanCreationException("cannot create dataSource", (Throwable)e);
            }
            String host = this.pg.getHost();
            int port = this.pg.getMappedPort(5432);
            String dbName = "db_" + port;
            DataSource dataSource = this.generateDatasource(host, port, "postgres", this.username, this.password);
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("DROP TEXT SEARCH CONFIGURATION IF EXISTS ru; DROP TEXT SEARCH DICTIONARY IF EXISTS ispell_ru; CREATE TEXT SEARCH DICTIONARY ispell_ru (\ntemplate= ispell,\ndictfile= ru,\nafffile=ru,\nstopwords = russian\n);\nCREATE TEXT SEARCH CONFIGURATION ru ( COPY = russian );\nALTER TEXT SEARCH CONFIGURATION ru\nALTER MAPPING\nFOR word, hword, hword_part\nWITH ispell_ru, russian_stem; DROP DATABASE IF EXISTS " + dbName + "; CREATE DATABASE " + dbName + ";");){
                preparedStatement.executeUpdate();
                DataSource ds = this.generateDatasource(host, port, dbName, this.username, this.password);
                try (Connection userDbCon = ds.getConnection();
                     PreparedStatement dictPreparedStatement = userDbCon.prepareStatement("DROP TEXT SEARCH CONFIGURATION IF EXISTS ru; DROP TEXT SEARCH DICTIONARY IF EXISTS ispell_ru; CREATE TEXT SEARCH DICTIONARY ispell_ru (\ntemplate= ispell,\ndictfile= ru,\nafffile=ru,\nstopwords = russian\n);\nCREATE TEXT SEARCH CONFIGURATION ru ( COPY = russian );\nALTER TEXT SEARCH CONFIGURATION ru\nALTER MAPPING\nFOR word, hword, hword_part\nWITH ispell_ru, russian_stem; ");){
                    dictPreparedStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                logger.error("cannot init db", (Throwable)e);
                throw new BeanCreationException("cannot create datasource", (Throwable)e);
            }
            return this.generateDatasource(host, port, dbName, this.username, this.password);
        }

        public final DataSource generateDatasource(String host, Integer port, String dbName, String username, String password) {
            PGSimpleDataSource ds = new PGSimpleDataSource();
            ds.setServerName(host);
            ds.setPortNumber(port.intValue());
            ds.setDatabaseName(dbName);
            ds.setUser(username);
            ds.setPassword(password);
            return ds;
        }
    }

    private static class TestContainersPgDataSourceFactoryBean
    implements FactoryBean<DataSource>,
    EnvironmentAware,
    InitializingBean {
        private TestcontainersPgDataSourceFactory factory;
        private DataSource testcontainersPgDatabase;

        private TestContainersPgDataSourceFactoryBean() {
        }

        public void setEnvironment(Environment environment) {
            this.factory = new TestcontainersPgDataSourceFactory(TestcontainersPgAutoConfiguration.psqlContainer(), "postgres", "postgres");
        }

        public void afterPropertiesSet() throws Exception {
            this.testcontainersPgDatabase = this.factory.getTestcontainersPgDatabase();
        }

        public DataSource getObject() throws Exception {
            return this.testcontainersPgDatabase;
        }

        public Class<?> getObjectType() {
            return PGSimpleDataSource.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Order(value=0x7FFFFFFF)
    private static class TestcontainersPgDataSourceBeanFactoryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Logger logger = LoggerFactory.getLogger(TestcontainersPgDataSourceBeanFactoryPostProcessor.class);

        private TestcontainersPgDataSourceBeanFactoryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, (String)"Testcontainers PG Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            this.process(registry, (DefaultListableBeanFactory)registry);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        }

        private void process(BeanDefinitionRegistry registry, DefaultListableBeanFactory beanFactory) {
            beanFactory.setAllowBeanDefinitionOverriding(true);
            BeanDefinitionHolder holder = this.getDataSourceBeanDefinition((ConfigurableListableBeanFactory)beanFactory);
            if (holder != null) {
                String beanName = holder.getBeanName();
                boolean primary = holder.getBeanDefinition().isPrimary();
                logger.info("Replacing '{}' DataSource bean with {} testcontainers pg version", (Object)beanName, (Object)(primary ? "primary " : ""));
                registry.registerBeanDefinition(beanName, this.createTestcontainersPgBeanDefinition(primary));
            }
        }

        private BeanDefinition createTestcontainersPgBeanDefinition(boolean primary) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(TestContainersPgDataSourceFactoryBean.class);
            beanDefinition.setPrimary(primary);
            return beanDefinition;
        }

        private BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
            Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
            if (ObjectUtils.isEmpty((Object[])beanNames)) {
                logger.warn("No DataSource beans found, testcontainers version will not be used");
                return null;
            }
            if (beanNames.length == 1) {
                Object beanName = beanNames[0];
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            for (Object beanName : beanNames) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                if (!beanDefinition.isPrimary()) continue;
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            logger.warn("No primary DataSource found, testcontainers pg version will not be used");
            return null;
        }
    }
}

