/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.test.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import net.n2oapp.platform.test.PortFinder;
import net.n2oapp.platform.test.autoconfigure.DefinePort;
import net.n2oapp.platform.test.autoconfigure.EnableEmbeddedPg;
import net.n2oapp.platform.test.autoconfigure.EnableTestcontainersPg;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class RandomPortEnvPostProcessor
implements EnvironmentPostProcessor {
    private static final String PROPERTY_SOURCE_NAME = "Inlined Test Properties";

    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        Class clazz = springApplication.getMainApplicationClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (clazz.getAnnotation(DefinePort.class) != null) {
            map.put("server.port", PortFinder.getPort("spring-boot"));
        }
        if (clazz.getAnnotation(EnableEmbeddedPg.class) != null) {
            map.put("test.embedded-pg", true);
        }
        if (clazz.getAnnotation(EnableTestcontainersPg.class) != null) {
            map.put("test.testcontainers-pg", true);
        }
        if (!map.isEmpty()) {
            this.addOrReplace(configurableEnvironment.getPropertySources(), map);
        }
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                ((Map)target.getSource()).put(entry.getKey(), entry.getValue());
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }
}

