/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.test.autoconfigure;

import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.n2oapp.platform.test.PortFinder;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Configuration
public class EmbeddedPgAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedPgAutoConfiguration.class);

    @Bean
    public static EmbeddedDataSourceBeanFactoryPostProcessor embeddedDataSourceBeanFactoryPostProcessor() {
        return new EmbeddedDataSourceBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="test", name={"embedded-pg"}, havingValue="true")
    public DataSource dataSource() {
        return new EmbeddedDataSourceFactory().getEmbeddedDatabase();
    }

    private static class EmbeddedDataSourceFactory {
        private EmbeddedDataSourceFactory() {
        }

        DataSource getEmbeddedDatabase() {
            EmbeddedPostgres pg;
            int port = PortFinder.getPort("embedded-postgres");
            String dbName = "db_" + port;
            try {
                pg = EmbeddedPostgres.builder().setCleanDataDirectory(true).setPort(port).start();
            }
            catch (IOException e) {
                logger.error("cannot build EmbeddedPostgres", (Throwable)e);
                throw new BeanCreationException("cannot create dataSource", (Throwable)e);
            }
            DataSource dataSource = pg.getPostgresDatabase();
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("DROP TEXT SEARCH CONFIGURATION IF EXISTS ru; DROP TEXT SEARCH DICTIONARY IF EXISTS ispell_ru; CREATE TEXT SEARCH DICTIONARY ispell_ru (\ntemplate= ispell,\ndictfile= ru,\nafffile=ru,\nstopwords = russian\n);\nCREATE TEXT SEARCH CONFIGURATION ru ( COPY = russian );\nALTER TEXT SEARCH CONFIGURATION ru\nALTER MAPPING\nFOR word, hword, hword_part\nWITH ispell_ru, russian_stem; DROP DATABASE IF EXISTS " + dbName + "; CREATE DATABASE " + dbName + ";");){
                preparedStatement.executeUpdate();
                DataSource ds = pg.getDatabase("postgres", dbName);
                try (Connection userDbCon = ds.getConnection();
                     PreparedStatement dictPreparedStatement = userDbCon.prepareStatement("DROP TEXT SEARCH CONFIGURATION IF EXISTS ru; DROP TEXT SEARCH DICTIONARY IF EXISTS ispell_ru; CREATE TEXT SEARCH DICTIONARY ispell_ru (\ntemplate= ispell,\ndictfile= ru,\nafffile=ru,\nstopwords = russian\n);\nCREATE TEXT SEARCH CONFIGURATION ru ( COPY = russian );\nALTER TEXT SEARCH CONFIGURATION ru\nALTER MAPPING\nFOR word, hword, hword_part\nWITH ispell_ru, russian_stem; ");){
                    dictPreparedStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                logger.error("cannot init db", (Throwable)e);
                throw new BeanCreationException("cannot create datasource", (Throwable)e);
            }
            return pg.getDatabase("postgres", dbName);
        }
    }

    private static class EmbeddedDataSourceFactoryBean
    implements FactoryBean<DataSource>,
    EnvironmentAware,
    InitializingBean {
        private EmbeddedDataSourceFactory factory;
        private DataSource embeddedDatabase;

        private EmbeddedDataSourceFactoryBean() {
        }

        public void setEnvironment(Environment environment) {
            this.factory = new EmbeddedDataSourceFactory();
        }

        public void afterPropertiesSet() throws Exception {
            this.embeddedDatabase = this.factory.getEmbeddedDatabase();
        }

        public DataSource getObject() throws Exception {
            return this.embeddedDatabase;
        }

        public Class<?> getObjectType() {
            return PGSimpleDataSource.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Order(value=0x7FFFFFFF)
    private static class EmbeddedDataSourceBeanFactoryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Logger logger = LoggerFactory.getLogger(EmbeddedDataSourceBeanFactoryPostProcessor.class);

        private EmbeddedDataSourceBeanFactoryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, (String)"Test Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            this.process(registry, (DefaultListableBeanFactory)registry);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        }

        private void process(BeanDefinitionRegistry registry, DefaultListableBeanFactory beanFactory) {
            beanFactory.setAllowBeanDefinitionOverriding(true);
            BeanDefinitionHolder holder = this.getDataSourceBeanDefinition((ConfigurableListableBeanFactory)beanFactory);
            if (holder != null) {
                String beanName = holder.getBeanName();
                boolean primary = holder.getBeanDefinition().isPrimary();
                logger.info("Replacing '{}' DataSource bean with {} embedded version", (Object)beanName, (Object)(primary ? "primary " : ""));
                registry.registerBeanDefinition(beanName, this.createEmbeddedBeanDefinition(primary));
            }
        }

        private BeanDefinition createEmbeddedBeanDefinition(boolean primary) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(EmbeddedDataSourceFactoryBean.class);
            beanDefinition.setPrimary(primary);
            return beanDefinition;
        }

        private BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
            Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
            if (ObjectUtils.isEmpty((Object[])beanNames)) {
                logger.warn("No DataSource beans found, embedded version will not be used");
                return null;
            }
            if (beanNames.length == 1) {
                Object beanName = beanNames[0];
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            for (Object beanName : beanNames) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                if (!beanDefinition.isPrimary()) continue;
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            logger.warn("No primary DataSource found, embedded version will not be used");
            return null;
        }
    }
}

