package net.n2oapp.platform.selection.api;

/**
 * Задает как на определенном уровне вложенности будут выбраны поля для отображения.
 */
public enum SelectionPropagation {

    /**
     * Выборка поля полностью определяется значениями {@link SelectionEnum}.
     * Это дефолтное поведение.
     */
    NORMAL,

    /**
     * Выборка всех полей (то есть игнорирование значений {@link SelectionEnum})
     * на этом (и только на этом) уровне вложенности.
     */
    ALL,

    /**
     * Полное игнорирование всех {@link SelectionEnum} на этом уровне,
     * а так же на любом вложенном уровне.
     * То есть будет выбрано каждое поле.
     */
    NESTED

}
