/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.selection.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

final class Util {
    private static final String MAGIC = "7";
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final char LPAREN = '0';
    private static final char RPAREN = '1';
    private static final char QUOTE = '-';
    private static final char COLON = '3';
    private static final char COMMA = '4';

    private Util() {
        throw new UnsupportedOperationException();
    }

    static String encode(String json) {
        if (json == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(MAGIC);
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                builder.append('0');
                continue;
            }
            if (c == '}') {
                builder.append('1');
                continue;
            }
            if (c == '\"') {
                builder.append('-');
                continue;
            }
            if (c == ':') {
                builder.append('3');
                continue;
            }
            if (c == ',') {
                builder.append('4');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static String decode(String encodedJson) {
        if (!encodedJson.startsWith(MAGIC)) {
            return encodedJson;
        }
        StringBuilder decodedJson = new StringBuilder();
        boolean identifier = false;
        for (int i = MAGIC.length(); i < encodedJson.length(); ++i) {
            char c = encodedJson.charAt(i);
            if (!identifier) {
                if (c == '0') {
                    decodedJson.append('{');
                    continue;
                }
                if (c == '1') {
                    decodedJson.append('}');
                    continue;
                }
                if (c == '-') {
                    identifier = true;
                    decodedJson.append('\"');
                    continue;
                }
                if (c == '3') {
                    decodedJson.append(':');
                    continue;
                }
                if (c == '4') {
                    decodedJson.append(',');
                    continue;
                }
                decodedJson.append(c);
                continue;
            }
            if (c == '-') {
                identifier = false;
                decodedJson.append('\"');
                continue;
            }
            decodedJson.append(c);
        }
        return decodedJson.toString();
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
    }
}

