/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.selection.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import net.n2oapp.platform.selection.api.SelectionPropagation;
import net.n2oapp.platform.selection.api.Util;

public interface Selection<T> {
    default public SelectionPropagation propagation() {
        return SelectionPropagation.NORMAL;
    }

    public boolean empty();

    public static String encode(Selection<?> selection) {
        if (selection == null) {
            return null;
        }
        try {
            String json = Util.MAPPER.writeValueAsString(selection);
            return Util.encode(json);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <S extends Selection<?>> S decode(String encodedJson, Class<S> target) {
        if (encodedJson == null || "".equals(encodedJson.trim())) {
            return null;
        }
        try {
            return (S)((Selection)Util.MAPPER.readValue(Util.decode(encodedJson), target));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

