/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.selection.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.platform.selection.api.Fetcher;
import net.n2oapp.platform.selection.api.Selection;
import net.n2oapp.platform.selection.api.SelectionPropagation;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;

public interface Joiner<T, S extends Selection<T>, E, F extends Fetcher<T, S, E>, ID> {
    public static final Supplier<ArrayList> ARRAY_LIST_SUPPLIER = ArrayList::new;

    @NonNull
    public ID getId(E var1);

    public Resolution<T, E, ID> resolveIterable(Iterable<? extends F> var1, S var2, SelectionPropagation var3);

    default public T resolve(F fetcher, S selection) {
        List<T> resolved = this.resolveCollection(Collections.singletonList(fetcher), selection);
        if (resolved == null) {
            return null;
        }
        return resolved.get(0);
    }

    default public <C extends Collection<T>> C resolveCollection(Collection<? extends F> fetchers, S selection, Supplier<? extends C> collectionSupplier) {
        if (selection == null) {
            return null;
        }
        Resolution<T, E, ID> resolution = this.resolveIterable(fetchers, selection, selection.propagation());
        if (resolution == null) {
            return null;
        }
        return (C)(collectionSupplier.equals(ARRAY_LIST_SUPPLIER) ? resolution.models : (Collection)resolution.models.stream().collect(Collectors.toCollection(collectionSupplier)));
    }

    default public List<T> resolveCollection(Collection<? extends F> fetchers, S selection) {
        return this.resolveCollection(fetchers, selection, ARRAY_LIST_SUPPLIER);
    }

    default public <I extends Streamable<T>> I resolveStreamable(Streamable<? extends F> fetchers, S selection) {
        if (selection == null) {
            return null;
        }
        Resolution<T, E, ID> resolution = this.resolveIterable((Iterable<? extends F>)fetchers, selection, selection.propagation());
        if (resolution == null) {
            return null;
        }
        int[] idx = new int[]{0};
        Streamable resolved = fetchers.map(fetcher -> {
            int n = idx[0];
            idx[0] = n + 1;
            return resolution.models.get(n);
        });
        return (I)resolved;
    }

    public static class Resolution<T, E, ID> {
        private static final Resolution<?, ?, ?> EMPTY = new Resolution(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new boolean[0]);
        public final List<E> uniqueEntities;
        public final List<ID> uniqueIds;
        public final List<T> models;
        public final boolean[] duplicate;

        private Resolution(List<E> uniqueEntities, List<ID> uniqueIds, List<T> models, boolean[] duplicate) {
            this.uniqueEntities = uniqueEntities;
            this.uniqueIds = uniqueIds;
            this.models = models;
            this.duplicate = duplicate;
        }

        public static <T, E, ID> Resolution<T, E, ID> from(List<E> uniqueEntities, List<ID> uniqueIds, List<T> models, boolean[] duplicate) {
            return new Resolution<T, E, ID>(uniqueEntities, uniqueIds, models, duplicate);
        }

        public static <T, E, ID> Resolution<T, E, ID> empty() {
            return EMPTY;
        }
    }
}

