/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.selection.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.n2oapp.platform.selection.api.Fetcher;
import org.springframework.util.Assert;

public final class JoinUtil {
    private JoinUtil() {
        throw new UnsupportedOperationException();
    }

    public static <ID, F extends Fetcher<?, ?, ?>, R, C extends Collection<F>> Map<ID, C> joinOneToMany(Supplier<Collection<R>> innerJoinRightSide, Function<? super R, ? extends F> fetcherConstructor, Function<? super R, ? extends ID> getLeftSideIdFromRightSide, Supplier<? extends C> targetCollectionSupplier) {
        HashMap<Object, Collection> result = new HashMap<Object, Collection>();
        Collection<R> childEntities = innerJoinRightSide.get();
        for (Object child : childEntities) {
            Fetcher fetcher = (Fetcher)Objects.requireNonNull(fetcherConstructor.apply(child));
            ID leftSideId = Objects.requireNonNull(getLeftSideIdFromRightSide.apply(child), () -> "Missing left side for INNER join for " + child);
            result.computeIfAbsent(leftSideId, ignored -> (Collection)targetCollectionSupplier.get()).add(fetcher);
        }
        return result;
    }

    public static <ID, F extends Fetcher<?, ?, ?>, R> Map<ID, List<F>> joinOneToMany(Supplier<Collection<R>> joinRightSide, Function<? super R, ? extends F> fetcherConstructor, Function<? super R, ? extends ID> getLeftSideIdFromRightSide) {
        return JoinUtil.joinOneToMany(joinRightSide, fetcherConstructor, getLeftSideIdFromRightSide, ArrayList::new);
    }

    public static <ID, F extends Fetcher<?, ?, ?>, L, R, C extends Collection<F>> Map<ID, C> joinToMany(Supplier<Set<L>> innerJoinRightSide, Function<? super R, ? extends F> fetcherConstructor, Function<? super L, ? extends ID> getLeftSideId, Function<? super L, Collection<R>> getRightSideByLeftSide, Supplier<? extends C> targetCollectionSupplier) {
        HashMap<ID, Collection> result = new HashMap<ID, Collection>();
        Set<L> joined = innerJoinRightSide.get();
        for (Object leftSideEntity : joined) {
            Object leftSideId = Objects.requireNonNull(getLeftSideId.apply(leftSideEntity));
            Collection<R> rightSide = getRightSideByLeftSide.apply(leftSideEntity);
            Assert.notEmpty(rightSide, () -> "Empty collection provided for INNER join. Left side entity: " + leftSideEntity + ", ID: " + leftSideId);
            JoinUtil.checkDuplicates(leftSideId, leftSideEntity, result);
            Collection manySideFetchers = (Collection)targetCollectionSupplier.get();
            result.put(leftSideId, manySideFetchers);
            for (R rightSideEntity : rightSide) {
                Fetcher fetcher = (Fetcher)Objects.requireNonNull(fetcherConstructor.apply(rightSideEntity));
                manySideFetchers.add(fetcher);
            }
        }
        return result;
    }

    public static <ID, F extends Fetcher<?, ?, ?>, L, R> Map<ID, List<F>> joinToMany(Supplier<Set<L>> innerJoin, Function<? super R, ? extends F> fetcherConstructor, Function<? super L, ? extends ID> getLeftSideId, Function<? super L, Collection<R>> getRightSideByLeftSide) {
        return JoinUtil.joinToMany(innerJoin, fetcherConstructor, getLeftSideId, getRightSideByLeftSide, ArrayList::new);
    }

    public static <LID, RID, F extends Fetcher<?, ?, ?>, L, R> Map<LID, F> joinToOne(Collection<L> leftSide, Supplier<Collection<R>> fetchRightSide, Function<? super R, ? extends F> fetcherConstructor, Function<? super L, ? extends LID> getLeftSideId, Function<? super L, ? extends RID> getForeignKey, Function<? super R, ? extends RID> getRightSideId) {
        HashMap<LID, Fetcher> result = new HashMap<LID, Fetcher>();
        HashMap<RID, R> joined = new HashMap<RID, R>();
        for (R rightSide : fetchRightSide.get()) {
            joined.putIfAbsent(getRightSideId.apply(rightSide), rightSide);
        }
        for (Object owner : leftSide) {
            Object fk = getForeignKey.apply(owner);
            if (fk == null) continue;
            Object r = joined.get(fk);
            LID leftSideId = Objects.requireNonNull(getLeftSideId.apply(owner));
            JoinUtil.checkDuplicates(leftSideId, owner, result);
            Objects.requireNonNull(r, () -> "Relationship present on " + owner + " for right side via foreign key " + fk + ", but could not be found on joined right side");
            Fetcher fetcher = (Fetcher)Objects.requireNonNull(fetcherConstructor.apply(r));
            result.put(leftSideId, fetcher);
        }
        return result;
    }

    public static <ID, F extends Fetcher<?, ?, ?>, L, R> Map<ID, F> joinToOnePrefetching(Collection<L> leftSide, Runnable prefetchRightSide, Function<? super R, ? extends F> fetcherConstructor, Function<? super L, ? extends R> getOtherSideFromLeftSide, Function<? super L, ? extends ID> getLeftSideId) {
        prefetchRightSide.run();
        HashMap<ID, Fetcher> result = new HashMap<ID, Fetcher>();
        for (L owner : leftSide) {
            R prefetchedOtherSide = getOtherSideFromLeftSide.apply(owner);
            if (prefetchedOtherSide == null) continue;
            ID leftSideId = Objects.requireNonNull(getLeftSideId.apply(owner));
            Fetcher fetcher = (Fetcher)Objects.requireNonNull(fetcherConstructor.apply(prefetchedOtherSide));
            JoinUtil.checkDuplicates(leftSideId, owner, result);
            result.put(leftSideId, fetcher);
        }
        return result;
    }

    public static <ID, F extends Fetcher<?, ?, ?>, R> Map<ID, F> joinOneToOne(Supplier<Collection<R>> fetchRightSide, Function<? super R, ? extends F> fetcherConstructor, Function<? super R, ? extends ID> getLeftSideIdFromRightSide) {
        HashMap<ID, Fetcher> result = new HashMap<ID, Fetcher>();
        Collection<R> owners = fetchRightSide.get();
        for (R owner : owners) {
            ID leftSideId = getLeftSideIdFromRightSide.apply(owner);
            if (leftSideId == null) continue;
            JoinUtil.checkDuplicates(leftSideId, owner, result);
            Fetcher fetcher = (Fetcher)Objects.requireNonNull(fetcherConstructor.apply(owner));
            result.put(leftSideId, fetcher);
        }
        return result;
    }

    private static void checkDuplicates(Object id, Object entity, Map<?, ?> result) {
        Assert.isTrue((!result.containsKey(id) ? 1 : 0) != 0, () -> "Duplicate id " + id + " for entity " + entity);
    }
}

