/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.security.autoconfigure;

import java.util.Collections;
import java.util.Map;
import net.n2oapp.platform.security.autoconfigure.N2oPlatformAuthenticationConverter;
import net.n2oapp.platform.security.autoconfigure.N2oPlatformResourceServerConfigurerAdapter;
import net.n2oapp.platform.security.autoconfigure.N2oPlatformSecurityProperties;
import net.n2oapp.platform.security.autoconfigure.PlatformAccessTokenConverter;
import net.n2oapp.platform.security.autoconfigure.PlatformRestTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={N2oPlatformSecurityProperties.class})
public class SecurityAutoConfiguration {
    private N2oPlatformSecurityProperties securityProperties;

    public SecurityAutoConfiguration(N2oPlatformSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
    public PlatformRestTemplate oauth2RestTemplate(OAuth2ClientContext oauth2ClientContext, OAuth2ProtectedResourceDetails details) {
        PlatformRestTemplate restTemplate = new PlatformRestTemplate(details, oauth2ClientContext);
        restTemplate.setRetryBadAccessTokens(false);
        restTemplate.setCheckTokenExpired(this.securityProperties.isCheckTokenExpired());
        return restTemplate;
    }

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
    public DefaultOAuth2ClientContext oauth2ClientContext(PlatformAccessTokenConverter accessTokenConverter) {
        OAuth2Authentication authentication;
        Object details;
        DefaultOAuth2ClientContext context = new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if (principal instanceof OAuth2Authentication && (details = (authentication = (OAuth2Authentication)principal).getDetails()) instanceof OAuth2AuthenticationDetails) {
            OAuth2AuthenticationDetails oauthsDetails = (OAuth2AuthenticationDetails)details;
            String tokenValue = oauthsDetails.getTokenValue();
            if (Boolean.FALSE.equals(this.securityProperties.isCheckTokenExpired())) {
                context.setAccessToken((OAuth2AccessToken)new DefaultOAuth2AccessToken(tokenValue));
            } else {
                OAuth2AccessToken accessToken = accessTokenConverter.extractAccessToken(tokenValue, accessTokenConverter.decode(tokenValue));
                context.setAccessToken(accessToken);
            }
        }
        return context;
    }

    @Bean
    public PlatformAccessTokenConverter platformAccessTokenConverter(UserAuthenticationConverter userAuthenticationConverter) {
        PlatformAccessTokenConverter platformAccessTokenConverter = new PlatformAccessTokenConverter();
        platformAccessTokenConverter.setUserTokenConverter(userAuthenticationConverter);
        return platformAccessTokenConverter;
    }

    @Bean
    public OAuth2ProtectedResourceDetails clientCredentialsResourceDetails() {
        ClientCredentialsResourceDetails clientCredentials = new ClientCredentialsResourceDetails();
        clientCredentials.setClientId(this.securityProperties.getClientId());
        clientCredentials.setClientSecret(this.securityProperties.getClientSecret());
        clientCredentials.setAccessTokenUri(this.securityProperties.getAccessTokenUri());
        return clientCredentials;
    }

    @Bean
    @ConditionalOnMissingBean
    public UserAuthenticationConverter n2oPlatformAuthenticationConverter() {
        SimpleAttributes2GrantedAuthoritiesMapper authoritiesMapper = new SimpleAttributes2GrantedAuthoritiesMapper();
        authoritiesMapper.setAttributePrefix(this.securityProperties.getAuthoritiesPrefix());
        authoritiesMapper.setConvertAttributeToUpperCase(this.securityProperties.isAuthoritiesUpperCase());
        authoritiesMapper.setConvertAttributeToLowerCase(this.securityProperties.isAuthoritiesLowerCase());
        return new N2oPlatformAuthenticationConverter(this.securityProperties.getUsernameKey(), this.securityProperties.getAuthoritiesKey(), (Attributes2GrantedAuthoritiesMapper)authoritiesMapper);
    }

    @Bean
    public ResourceServerTokenServices tokenServices(final TokenStore tokenStore) {
        DefaultTokenServices defaultTokenServices = Boolean.FALSE.equals(this.securityProperties.isCheckTokenExpired()) ? new DefaultTokenServices(){

            public OAuth2Authentication loadAuthentication(String accessTokenValue) {
                OAuth2AccessToken accessToken = tokenStore.readAccessToken(accessTokenValue);
                if (accessToken == null) {
                    throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
                }
                OAuth2Authentication result = tokenStore.readAuthentication(accessToken);
                if (result == null) {
                    throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
                }
                return result;
            }
        } : new DefaultTokenServices();
        defaultTokenServices.setTokenStore(tokenStore);
        defaultTokenServices.setSupportRefreshToken(true);
        return defaultTokenServices;
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenStore tokenStore(UserAuthenticationConverter userAuthenticationConverter) {
        DefaultAccessTokenConverter accessTokenConverter = new DefaultAccessTokenConverter(){

            public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
                if (Boolean.FALSE.equals(SecurityAutoConfiguration.this.securityProperties.isCheckAud())) {
                    map.remove("aud");
                }
                return super.extractAuthentication(map);
            }
        };
        accessTokenConverter.setUserTokenConverter(userAuthenticationConverter);
        Assert.hasText((String)this.securityProperties.getKeySetUri(), (String)"Set property `n2o.platform.security.key-set-uri`");
        return new JwkTokenStore(Collections.singletonList(this.securityProperties.getKeySetUri()), (AccessTokenConverter)accessTokenConverter, null);
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceServerConfigurer.class})
    public ResourceServerConfigurer n2oPlatformResourceServer() {
        N2oPlatformResourceServerConfigurerAdapter adapter = new N2oPlatformResourceServerConfigurerAdapter();
        adapter.setSecurityProperties(this.securityProperties);
        return adapter;
    }
}

