/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.security.autoconfigure;

import java.util.Map;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;

public class PlatformAccessTokenConverter
extends DefaultAccessTokenConverter {
    private JsonParser objectMapper = JsonParserFactory.create();

    public Map<String, Object> decode(String token) {
        try {
            Jwt jwt = JwtHelper.decode((String)token);
            String claimsStr = jwt.getClaims();
            Map claims = this.objectMapper.parseMap(claimsStr);
            if (claims.containsKey("exp") && claims.get("exp") instanceof Integer) {
                Integer intValue = (Integer)claims.get("exp");
                claims.put("exp", Long.valueOf(intValue.intValue()));
            }
            return claims;
        }
        catch (Exception e) {
            throw new InvalidTokenException("Cannot convert access token to JSON", (Throwable)e);
        }
    }
}

