/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.security.autoconfigure;

import net.n2oapp.platform.security.autoconfigure.N2oPlatformSecurityProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;

public class N2oPlatformResourceServerConfigurerAdapter
extends ResourceServerConfigurerAdapter {
    @Autowired
    private N2oPlatformSecurityProperties securityProperties;

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.resourceId(this.securityProperties.getResourceId());
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)http.httpBasic().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        this.configure(http.authorizeRequests());
    }

    public void configure(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated();
    }

    public void setSecurityProperties(N2oPlatformSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

