/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.security.autoconfigure;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;

public class N2oPlatformAuthenticationConverter
implements UserAuthenticationConverter {
    private UserDetailsService userDetailsService;
    private String usernameKey;
    private String authoritiesKey;
    private Attributes2GrantedAuthoritiesMapper authoritiesMapper;
    private Collection<GrantedAuthority> defaultAuthorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"});

    public N2oPlatformAuthenticationConverter(String usernameKey, String authoritiesKey) {
        this.usernameKey = usernameKey;
        this.authoritiesKey = authoritiesKey;
    }

    public N2oPlatformAuthenticationConverter(String usernameKey, String authoritiesKey, Attributes2GrantedAuthoritiesMapper authoritiesMapper) {
        this(usernameKey, authoritiesKey);
        this.authoritiesMapper = authoritiesMapper;
    }

    public Map<String, ?> convertUserAuthentication(Authentication authentication) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put(this.usernameKey, authentication.getName());
        if (authentication.getAuthorities() != null && !authentication.getAuthorities().isEmpty()) {
            response.put(this.authoritiesKey, AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities()));
        }
        return response;
    }

    public Authentication extractAuthentication(Map<String, ?> map) {
        if (map.containsKey(this.usernameKey)) {
            Object principal = map.get(this.usernameKey);
            Collection authorities = this.getAuthorities(map);
            if (this.userDetailsService != null) {
                UserDetails user = this.userDetailsService.loadUserByUsername((String)map.get(this.usernameKey));
                authorities = user.getAuthorities();
                principal = user;
            }
            return new UsernamePasswordAuthenticationToken(principal, (Object)"N/A", authorities);
        }
        return null;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setUsernameKey(String usernameKey) {
        this.usernameKey = usernameKey;
    }

    public void setAuthoritiesKey(String authoritiesKey) {
        this.authoritiesKey = authoritiesKey;
    }

    public void setDefaultAuthorities(Collection<GrantedAuthority> defaultAuthorities) {
        this.defaultAuthorities = defaultAuthorities;
    }

    public void setAuthoritiesMapper(Attributes2GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    protected Collection<GrantedAuthority> getAuthorities(Map<String, ?> map) {
        Object authorities = map.get(this.authoritiesKey);
        if (authorities == null) {
            return this.defaultAuthorities;
        }
        if (!(authorities instanceof String) && !(authorities instanceof Collection)) {
            throw new IllegalArgumentException("Authorities must be either a String or a Collection");
        }
        List<String> authorityColl = authorities instanceof String ? Arrays.asList(((String)authorities).split(",")) : (Collection)((Collection)authorities).stream().map(Object::toString).collect(Collectors.toList());
        return this.authoritiesMapper.getGrantedAuthorities(authorityColl);
    }
}

