/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.jaxrs.CodeGenerator;
import net.n2oapp.platform.jaxrs.RestException;
import net.n2oapp.platform.jaxrs.RestExceptionMapper;
import net.n2oapp.platform.jaxrs.RestMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestServerExceptionMapper
implements RestExceptionMapper<Exception> {
    private static final Logger logger = LoggerFactory.getLogger(RestServerExceptionMapper.class);
    private boolean canExportStack;
    private Messages messages;

    public RestServerExceptionMapper(boolean canExportStack, Messages messages) {
        this.canExportStack = canExportStack;
        this.messages = messages;
    }

    public RestMessage toMessage(Exception exception) {
        String code = CodeGenerator.generate((String)this.getPrefix());
        logger.error(code, (Throwable)exception);
        RestMessage message = new RestMessage(code);
        if (this.canExportStack) {
            message.setStackTrace(ExceptionUtils.getStackFrames((Throwable)exception));
        }
        return message;
    }

    public Response toResponse(Exception exception) {
        return Response.status((Response.Status)this.getStatus()).entity((Object)this.toMessage(exception)).header("exception-class", (Object)RestException.class.getName()).type("application/json;charset=UTF-8").build();
    }

    private String getPrefix() {
        String prefix = this.messages.getMessage("ui.error-prefix", new Object[0]);
        if (prefix.equals("ui.error-prefix")) {
            return null;
        }
        return prefix;
    }
}

