/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import java.lang.reflect.Type;
import java.util.Arrays;
import net.n2oapp.platform.jaxrs.TypedParamConverter;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.StringUtils;

public class MissingGenericBean
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (metadata instanceof MethodMetadata) {
            ConditionMessage matchMessage = ConditionMessage.empty();
            matchMessage.andCondition(MissingGenericBean.class.getSimpleName(), new Object[0]).didNotFind("any beans").atAll();
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            String[] beanNamesForType = beanFactory.getBeanNamesForType(TypedParamConverter.class);
            if (beanNamesForType.length == 0) {
                return new ConditionOutcome(true, matchMessage);
            }
            try {
                Type genericReturnType = Class.forName(((MethodMetadata)metadata).getDeclaringClassName()).getMethod(((MethodMetadata)metadata).getMethodName(), new Class[0]).getGenericReturnType();
                beanNamesForType = beanFactory.getBeanNamesForType(ResolvableType.forType((Type)genericReturnType));
                if (beanNamesForType.length == 0) {
                    return new ConditionOutcome(true, matchMessage);
                }
                StringBuilder reason = new StringBuilder();
                reason.append("found beans named ");
                reason.append(StringUtils.collectionToDelimitedString(Arrays.asList(beanNamesForType), (String)", "));
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition((String)MissingGenericBean.class.getSimpleName(), (Object[])new Object[0]).because(reason.toString()));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException("may be annotated only method");
    }
}

