/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Path;
import net.n2oapp.platform.jaxrs.autoconfigure.EnableJaxRsProxyClient;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsProxyClientFactoryBean;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class JaxRsProxyClientRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment environment;
    private List<Class<?>> classes = Collections.emptyList();
    private String scanPackages;
    private String address;
    private String accept;
    private String contentType;
    private Boolean threadSafe;
    private String connectionTimeout;
    private String receiveTimeout;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.overrideProperties(importingClassMetadata);
        if (this.classes.isEmpty()) {
            this.classes = this.findClasses();
        }
        this.classes.forEach(c -> this.registerJaxRsProxyClient(registry, (Class<?>)c));
    }

    private void overrideProperties(AnnotationMetadata importingClassMetadata) {
        String[] scanPackages;
        Class[] classes;
        Class<EnableJaxRsProxyClient> annoType = EnableJaxRsProxyClient.class;
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(annoType.getName(), false);
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)annotationAttributes);
        if (attributes == null) {
            return;
        }
        String address = attributes.getString("address");
        if (address != null && !address.isEmpty()) {
            this.address = this.environment.resolvePlaceholders(address);
        }
        if ((classes = attributes.getClassArray("classes")) == null || classes.length == 0) {
            classes = attributes.getClassArray("value");
        }
        if (classes != null && classes.length > 0) {
            this.classes = Arrays.asList(classes);
        }
        if ((scanPackages = attributes.getStringArray("scanPackages")) != null && scanPackages.length > 0) {
            Optional<String> reduceResult = Stream.of(scanPackages).reduce((a, b) -> a + "," + b);
            reduceResult.ifPresent(s -> {
                this.scanPackages = s;
            });
        }
    }

    private List<Class<?>> findClasses() {
        Map classes;
        if (this.scanPackages == null) {
            throw new IllegalArgumentException("You need to set property [cxf.jaxrs.client.classes-scan-packages]");
        }
        try {
            classes = ClasspathScanner.findClasses((String)this.scanPackages, (Class[])new Class[]{Path.class});
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        return ((Collection)classes.get(Path.class)).stream().filter(Class::isInterface).collect(Collectors.toList());
    }

    private void registerJaxRsProxyClient(BeanDefinitionRegistry beanRegistry, Class<?> restClass) {
        AbstractBeanDefinition definition = BeanDefinitionBuilder.genericBeanDefinition(JaxRsProxyClientFactoryBean.class).addPropertyReference("bus", "cxf").addPropertyValue("serviceClass", restClass).addPropertyValue("address", (Object)this.address).addPropertyValue("accept", (Object)this.accept).addPropertyValue("threadSafe", (Object)this.threadSafe).addPropertyValue("contentType", (Object)this.contentType).addPropertyValue("connectionTimeout", (Object)this.connectionTimeout).addPropertyValue("receiveTimeout", (Object)this.receiveTimeout).getBeanDefinition();
        String beanName = this.generateProxyBeanName(restClass);
        beanRegistry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    private String generateProxyBeanName(Class<?> restClass) {
        return restClass.getSimpleName().substring(0, 1).toLowerCase().concat(restClass.getSimpleName().substring(1)) + "JaxRsProxyClient";
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        this.scanPackages = environment.getProperty("cxf.jaxrs.client.classes-scan-packages");
        this.address = environment.getProperty("cxf.jaxrs.client.address");
        this.accept = environment.getProperty("cxf.jaxrs.client.accept", "");
        this.contentType = environment.getProperty("cxf.jaxrs.client.content-type", "");
        this.threadSafe = (Boolean)environment.getProperty("cxf.jaxrs.client.thread-safe", Boolean.class, (Object)false);
        this.connectionTimeout = environment.getProperty("cxf.jaxrs.client.connection.timeout");
        this.receiveTimeout = environment.getProperty("cxf.jaxrs.client.receive.timeout");
    }
}

