/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.n2oapp.platform.jaxrs.DateISOParameterConverter;
import net.n2oapp.platform.jaxrs.LocalDateTimeISOParameterConverter;
import net.n2oapp.platform.jaxrs.MapperConfigurer;
import net.n2oapp.platform.jaxrs.OrderParameterConverter;
import net.n2oapp.platform.jaxrs.RestObjectMapperConfigurer;
import net.n2oapp.platform.jaxrs.SortParameterConverter;
import net.n2oapp.platform.jaxrs.TypedParamConverter;
import net.n2oapp.platform.jaxrs.TypedParametersProvider;
import net.n2oapp.platform.jaxrs.XmlProvider;
import net.n2oapp.platform.jaxrs.ZonedDateTimeParamConverter;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsClientAutoConfiguration;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsServerAutoConfiguration;
import net.n2oapp.platform.jaxrs.autoconfigure.MissingGenericBean;
import net.n2oapp.platform.jaxrs.seek.SeekPivotParameterConverter;
import org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.domain.Sort;

@Configuration
@AutoConfigureBefore(value={CxfAutoConfiguration.class, JaxRsServerAutoConfiguration.class, JaxRsClientAutoConfiguration.class})
@PropertySource(value={"classpath:/META-INF/net/n2oapp/platform/jaxrs/default.properties"})
public class JaxRsCommonAutoConfiguration {
    private List<MapperConfigurer> mapperConfigurers;

    public JaxRsCommonAutoConfiguration(@Autowired(required=false) List<MapperConfigurer> mapperConfigurers) {
        this.mapperConfigurers = mapperConfigurers;
    }

    @ConditionalOnMissingBean(name={"cxfObjectMapper"})
    @Primary
    @Bean(value={"cxfObjectMapper"})
    public ObjectMapper cxfObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        RestObjectMapperConfigurer.configure((ObjectMapper)objectMapper, this.mapperConfigurers);
        return objectMapper;
    }

    @Bean
    JacksonJsonProvider jsonProvider(@Qualifier(value="cxfObjectMapper") ObjectMapper cxfObjectMapper) {
        return new JacksonJsonProvider(cxfObjectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
    }

    @Bean
    XmlProvider xmlProvider() {
        XmlMapper xmlMapper = new XmlMapper();
        RestObjectMapperConfigurer.configure((XmlMapper)xmlMapper, this.mapperConfigurers);
        return new XmlProvider(xmlMapper);
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<Date> dateParameterConverter() {
        return new DateISOParameterConverter();
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<LocalDateTime> localDateTimeParameterConverter() {
        return new LocalDateTimeISOParameterConverter();
    }

    @Bean
    public TypedParamConverter<Sort.Order> orderParamConverter() {
        return new OrderParameterConverter();
    }

    @Bean
    public TypedParamConverter<Sort> sortParamConverter() {
        return new SortParameterConverter();
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<ZonedDateTime> zonedDateTimeTypedParamConverter() {
        return new ZonedDateTimeParamConverter();
    }

    @Bean
    TypedParametersProvider typedParametersProvider(Set<TypedParamConverter<?>> converters) {
        return new TypedParametersProvider(converters);
    }

    @Bean
    @ConditionalOnClass(name={"net.n2oapp.platform.seek.SeekableRepository"})
    public SeekPivotParameterConverter seekPivotParameterConverter() {
        return new SeekPivotParameterConverter();
    }
}

