/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.impl;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import net.n2oapp.platform.i18n.Message;
import net.n2oapp.platform.i18n.UserException;
import net.n2oapp.platform.jaxrs.CollectionUtil;
import net.n2oapp.platform.jaxrs.api.AbstractModel;
import net.n2oapp.platform.jaxrs.api.IntegerModel;
import net.n2oapp.platform.jaxrs.api.ListModel;
import net.n2oapp.platform.jaxrs.api.MapParamHolder;
import net.n2oapp.platform.jaxrs.api.SomeCriteria;
import net.n2oapp.platform.jaxrs.api.SomeModel;
import net.n2oapp.platform.jaxrs.api.SomeRest;
import net.n2oapp.platform.jaxrs.api.StringModel;
import net.n2oapp.platform.jaxrs.seek.RequestedPageEnum;
import net.n2oapp.platform.jaxrs.seek.SeekPivot;
import net.n2oapp.platform.jaxrs.seek.SeekRequest;
import net.n2oapp.platform.jaxrs.seek.SeekedPageImpl;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Controller
public class SomeRestImpl
implements SomeRest {
    @Context
    private HttpHeaders httpHeaders;
    public static final List<SeekPivot> EXPECTED_PIVOTS = CollectionUtil.listOf(SeekPivot.of((String)"id", (String)"54,3"), SeekPivot.of((String)"date", (String)"1,970-01-01"), SeekPivot.of((String)"plain-text", (String)",ABRACA:::::DAB:::::RA\\\u0425\u044b\u0445\u044b\u0445\u044b"), SeekPivot.of((String)"triplesix", (String)",\u7570\u4f53\u5b57"));

    @Override
    public Page<SomeModel> search(SomeCriteria criteria) {
        List<SomeModel> content = this.findAll(criteria);
        return new PageImpl(content, (Pageable)criteria, this.count(criteria).longValue());
    }

    @Override
    public Page<AbstractModel> searchModel(SomeCriteria criteria) {
        return new PageImpl(Collections.singletonList(new StringModel("ABRACADABRA")), (Pageable)criteria, 1L);
    }

    @Override
    public List<SomeModel> searchWithoutTotalElements(SomeCriteria criteria) {
        return this.findAll(criteria);
    }

    @Override
    public Long count(SomeCriteria criteria) {
        return 100L;
    }

    @Override
    public SomeModel getById(Long id) {
        SomeModel someModel = new SomeModel(id);
        someModel.setDate(new Date());
        someModel.setDateEnd(LocalDateTime.now());
        someModel.setName("SOME_NAME");
        return someModel;
    }

    @Override
    public Long create(SomeModel model) {
        return 1L;
    }

    @Override
    public void update(SomeModel model) {
        if (model.getId() == null) {
            throw new IllegalArgumentException("Field [id] mustn't be null");
        }
        if (model.getId() < 0L) {
            throw new UserException(new Message("example.idPositive").set((Object)model.getId()));
        }
    }

    @Override
    public void delete(Long id) {
    }

    @Override
    public void throwErrors() {
        ArrayList<Message> messages = new ArrayList<Message>(3);
        messages.add(new Message("user.error1", new Object[]{"\u0440\u0430\u0437"}));
        messages.add(new Message("user.error1", new Object[]{"\u0434\u0432\u0430"}));
        messages.add(new Message("user.error2"));
        throw new UserException(messages);
    }

    @Override
    public String timeoutSuccess() throws InterruptedException {
        Thread.sleep(500L);
        return "timeout success";
    }

    @Override
    public String timeoutFailure() throws InterruptedException {
        Thread.sleep(1500L);
        return "timeout failure";
    }

    @Override
    public List<LocalDateTime> searchBySetOfTypedList(Set<List<LocalDateTime>> setOfList) {
        return (List)setOfList.stream().findFirst().get();
    }

    @Override
    public Map<String, String> searchBySetOfTypedMap(Map<String, String> map) {
        return map;
    }

    @Override
    public Map<String, String> authHeader() {
        return CollectionUtil.mapOf("Authorization", this.httpHeaders.getHeaderString("Authorization"));
    }

    @Override
    public List<AbstractModel<?>> getListOfAbstractModels() {
        return CollectionUtil.listOf(new StringModel("1"), new IntegerModel(2));
    }

    @Override
    public List<ListModel> getListModels() {
        return CollectionUtil.listOf(new ListModel(CollectionUtil.listOf(new IntegerModel(0), new IntegerModel(1), new IntegerModel(2))), new ListModel(CollectionUtil.listOf(new IntegerModel(3), new IntegerModel(4), new IntegerModel(5))));
    }

    public SeekedPageImpl<String> searchSeeking(SeekRequest request) {
        if (request.getPage() == RequestedPageEnum.NEXT && request.getSize() == 1000 && request.getSort().equals((Object)Sort.by(CollectionUtil.listOf(Sort.Order.asc((String)"id"), Sort.Order.desc((String)"name")))) && request.getPivots().equals(EXPECTED_PIVOTS)) {
            return SeekedPageImpl.of(CollectionUtil.listOf("ok!"), (boolean)true, (boolean)false);
        }
        return null;
    }

    @Override
    public Map<String, String> mapQueryParam(Map<String, String> map) {
        return map;
    }

    @Override
    public Map<String, String> mapQueryParamViaHolder(MapParamHolder holder) {
        return holder.getMap();
    }

    private List<SomeModel> findAll(SomeCriteria criteria) {
        return LongStream.range(criteria.getOffset(), criteria.getOffset() + (long)criteria.getPageSize()).mapToObj(id -> this.model(id, criteria)).collect(Collectors.toList());
    }

    private SomeModel model(long id, SomeCriteria criteria) {
        SomeModel model = new SomeModel(id);
        model.setDate(criteria.getDateBegin());
        model.setName(criteria.getLikeName());
        model.setDateEnd(criteria.getDateEnd());
        return model;
    }
}

