/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.time.LocalDateTime;
import java.util.Date;
import net.n2oapp.platform.jaxrs.CollectionUtil;
import net.n2oapp.platform.jaxrs.RestCriteria;
import net.n2oapp.platform.jaxrs.api.SomeCriteria;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.springframework.data.domain.Sort;

@RunWith(value=JUnit4.class)
public class RestCriteriaTest {
    @Test
    public void testMoveToFirstPage() {
        SomeCriteria someCriteria = this.createSomeCriteria(15);
        RestCriteria first = someCriteria.first();
        Assert.assertEquals((long)0L, (long)first.getPageNumber());
        this.assertCriteriasEqByFiltersAndSortAndPageSize(someCriteria, (SomeCriteria)first);
    }

    @Test
    public void testPaginateForward() {
        SomeCriteria someCriteria = this.createSomeCriteria(54);
        RestCriteria next = someCriteria.next();
        Assert.assertEquals((long)(someCriteria.getPageNumber() + 1), (long)next.getPageNumber());
        this.assertCriteriasEqByFiltersAndSortAndPageSize(someCriteria, (SomeCriteria)next);
    }

    @Test
    public void testPaginateBackward() {
        SomeCriteria someCriteria = this.createSomeCriteria(3);
        RestCriteria prev = someCriteria.previous();
        Assert.assertEquals((long)(someCriteria.getPageNumber() - 1), (long)prev.getPageNumber());
    }

    @Test(expected=IllegalStateException.class)
    public void testPaginateBackwardWhenBeginningReached() {
        SomeCriteria someCriteria = this.createSomeCriteria(0);
        someCriteria.previous();
    }

    private SomeCriteria createSomeCriteria(int pageNumber) {
        Date dateBegin = new Date();
        LocalDateTime dateEnd = LocalDateTime.now();
        String nameLike = "TEST_STR";
        int pageSize = 13;
        SomeCriteria someCriteria = new SomeCriteria(pageNumber, pageSize, Sort.by(CollectionUtil.listOf(Sort.Order.asc((String)"nameLike"), Sort.Order.desc((String)"dateBegin"))));
        someCriteria.setLikeName(nameLike);
        someCriteria.setDateBegin(dateBegin);
        someCriteria.setDateEnd(dateEnd);
        return someCriteria;
    }

    private void assertCriteriasEqByFiltersAndSortAndPageSize(SomeCriteria criteria1, SomeCriteria criteria2) {
        Assert.assertEquals((Object)criteria1.getLikeName(), (Object)criteria2.getLikeName());
        Assert.assertEquals((Object)criteria1.getDateBegin(), (Object)criteria2.getDateBegin());
        Assert.assertEquals((Object)criteria1.getDateEnd(), (Object)criteria2.getDateEnd());
        Assert.assertEquals((Object)criteria1.getSort(), (Object)criteria2.getSort());
        Assert.assertEquals((long)criteria1.getPageSize(), (long)criteria2.getPageSize());
    }
}

