/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import net.n2oapp.platform.jaxrs.Application;
import net.n2oapp.platform.jaxrs.CollectionUtil;
import net.n2oapp.platform.jaxrs.XmlProvider;
import net.n2oapp.platform.jaxrs.api.SomeModel;
import org.apache.cxf.jaxrs.client.WebClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootApplication
@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={JaxRsServerTest.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class JaxRsServerTest {
    @LocalServerPort
    private int port;
    @Autowired
    private JacksonJsonProvider jsonProvider;
    @Autowired
    private XmlProvider xmlProvider;

    @Test
    public void info() {
        this.forEachClient(webClient -> {
            Response response = webClient.path((Object)"info").get();
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.equalTo((Object)200));
            String html = (String)response.readEntity(String.class);
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"Endpoint address"));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"Swagger"));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"WADL"));
        });
    }

    @Test
    public void testSearchHead() {
        this.forEachClient(webClient -> {
            Response response = webClient.path((Object)"example").path((Object)"search").head();
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.equalTo((Object)200));
        });
    }

    @Test
    public void paging() {
        this.forEachClient(webClient -> {
            Page page = (Page)webClient.path((Object)"example").path((Object)"search").query("size", new Object[]{20}).query("page", new Object[]{2}).get(Page.class);
            MatcherAssert.assertThat((Object)page.getTotalElements(), (Matcher)CoreMatchers.equalTo((Object)100L));
            MatcherAssert.assertThat((Object)page.getContent(), (Matcher)Matchers.instanceOf(List.class));
            List content = page.getContent();
            MatcherAssert.assertThat((Object)content.size(), (Matcher)CoreMatchers.equalTo((Object)20));
            MatcherAssert.assertThat((Object)((Map)content.get(0)).get("id").toString(), (Matcher)CoreMatchers.equalTo((Object)"40"));
        });
    }

    @Test
    public void pagingByDefault() {
        this.forEachClient(webClient -> {
            Page page = (Page)webClient.path((Object)"example").path((Object)"search").get(Page.class);
            MatcherAssert.assertThat((Object)page.getTotalElements(), (Matcher)CoreMatchers.equalTo((Object)100L));
            MatcherAssert.assertThat((Object)page.getContent(), (Matcher)Matchers.instanceOf(List.class));
            List content = page.getContent();
            MatcherAssert.assertThat((Object)content.size(), (Matcher)CoreMatchers.equalTo((Object)10));
            MatcherAssert.assertThat((Object)((Map)content.get(0)).get("id").toString(), (Matcher)CoreMatchers.equalTo((Object)"0"));
        });
    }

    @Test
    public void sort() {
        this.forEachClient(webClient -> {
            Page page = (Page)webClient.path((Object)"example").path((Object)"search").query("sort", new Object[]{"name: asc", "id: desc"}).get(Page.class);
            MatcherAssert.assertThat((Object)page.getSort(), (Matcher)CoreMatchers.notNullValue());
            Sort sort = page.getSort();
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                orders.add(order);
            }
            MatcherAssert.assertThat((Object)orders.size(), (Matcher)CoreMatchers.equalTo((Object)2));
            MatcherAssert.assertThat((Object)((Sort.Order)orders.get(0)).getProperty(), (Matcher)CoreMatchers.equalTo((Object)"name"));
            MatcherAssert.assertThat((Object)((Sort.Order)orders.get(0)).getDirection().toString(), (Matcher)Matchers.equalToIgnoringCase((String)"asc"));
            MatcherAssert.assertThat((Object)((Sort.Order)orders.get(1)).getProperty(), (Matcher)CoreMatchers.equalTo((Object)"id"));
            MatcherAssert.assertThat((Object)((Sort.Order)orders.get(1)).getDirection().toString(), (Matcher)Matchers.equalToIgnoringCase((String)"desc"));
        });
    }

    @Test
    public void pageResult() {
        this.forEachClient(webClient -> {
            Page page = (Page)webClient.path((Object)"example").path((Object)"search").get(Page.class);
            MatcherAssert.assertThat((Object)page.getContent(), (Matcher)Matchers.instanceOf(List.class));
            MatcherAssert.assertThat((Object)page.getTotalElements(), (Matcher)Matchers.instanceOf(Number.class));
        });
    }

    @Test
    public void sortResult() {
        this.forEachClient(webClient -> {
            Page page = (Page)webClient.path((Object)"example").path((Object)"search").query("sort", new Object[]{"name: asc"}).get(Page.class);
            Sort sort = page.getSort();
            int numSorts = 0;
            for (Sort.Order ignored : sort) {
                ++numSorts;
            }
            MatcherAssert.assertThat((Object)numSorts, (Matcher)CoreMatchers.equalTo((Object)1));
        });
    }

    @Test
    public void listResult() {
        this.forEachClient(webClient -> {
            List list = (List)webClient.path((Object)"example").path((Object)"list").get(List.class);
            MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.notNullValue());
        });
    }

    @Test
    public void idResult() {
        this.forEachClient(webClient -> {
            if (((String)webClient.getHeaders().getFirst((Object)"Accept")).equals("application/xml")) {
                return;
            }
            Long result = (Long)webClient.path((Object)"example").path((Object)"count").get(Long.class);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)100L));
        });
    }

    @Test
    public void singleResult() {
        this.forEachClient(webClient -> {
            SomeModel result = (SomeModel)webClient.path((Object)"example").path((Object)1).get(SomeModel.class);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)result.getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
        });
    }

    @Test
    public void filters() {
        this.forEachClient(webClient -> {
            Page page = (Page)webClient.path((Object)"example").path((Object)"search").query("name", new Object[]{"John"}).query("date", new Object[]{"2018-03-01T08:00:00.000+00:00"}).query("dateEnd", new Object[]{"2018-03-31T08:00:00"}).get(Page.class);
            List content = page.getContent();
            MatcherAssert.assertThat(((Map)content.get(0)).get("name"), (Matcher)CoreMatchers.equalTo((Object)"John"));
            MatcherAssert.assertThat(((Map)content.get(0)).get("date"), (Matcher)CoreMatchers.equalTo((Object)"2018-03-01T08:00:00.000+00:00"));
            MatcherAssert.assertThat(((Map)content.get(0)).get("dateEnd"), (Matcher)CoreMatchers.equalTo((Object)"2018-03-31T08:00:00"));
        });
    }

    @Test
    public void validations() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("name", "");
        model.put("date", "2030-01-01T12:00:00Z");
        this.forEachClient(webClient -> {
            Response response = webClient.path((Object)"example").post((Object)model);
            MatcherAssert.assertThat((Object)response.getStatusInfo().getFamily(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.Family.CLIENT_ERROR));
            Map message = (Map)response.readEntity(Map.class);
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat(message.get("errors"), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)((List)message.get("errors")).size(), (Matcher)CoreMatchers.equalTo((Object)2));
        });
    }

    @Test
    public void testGetById() {
        this.forEachClient(webClient -> {
            SomeModel model = (SomeModel)webClient.path((Object)"example").path("{id}", new Object[]{50}).get(SomeModel.class);
            Assert.assertNotNull((Object)model);
            Assert.assertNotNull((Object)model.getId());
            Assert.assertNotNull((Object)model.getName());
            Assert.assertNotNull((Object)model.getDate());
            Assert.assertNotNull((Object)model.getDateEnd());
        });
    }

    @Test
    public void testDefaultContentTypeIsJson() {
        WebClient client = WebClient.create((String)("http://localhost:" + this.port), CollectionUtil.listOf(this.jsonProvider, this.xmlProvider)).accept(new String[]{"application/xml", "application/json"}).type("application/json").path((Object)"api");
        Response response = client.path((Object)"example").path("{id}", new Object[]{50}).get();
        String contentType = response.getHeaderString("Content-Type");
        Assert.assertEquals((Object)"application/json", (Object)contentType);
    }

    private void forEachClient(Consumer<WebClient> clientConsumer) {
        for (WebClient client : this.clients()) {
            try {
                clientConsumer.accept(client);
            }
            catch (Exception e) {
                System.out.println("ERROR AT SUCH HEADERS: " + client.getHeaders());
                throw e;
            }
        }
    }

    private WebClient[] clients() {
        WebClient[] clients = new WebClient[Application.HEADERS.length];
        for (int i = 0; i < clients.length; ++i) {
            String accept = Application.HEADERS[i].get("Accept");
            String contentType = Application.HEADERS[i].get("Content-Type");
            clients[i] = WebClient.create((String)("http://localhost:" + this.port), CollectionUtil.listOf(this.jsonProvider, this.xmlProvider)).accept(new String[]{accept}).type(contentType).path((Object)"api");
        }
        return clients;
    }
}

