/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedHashMap;
import net.n2oapp.platform.jaxrs.Application;
import net.n2oapp.platform.jaxrs.CollectionUtil;
import net.n2oapp.platform.jaxrs.MapperConfigurer;
import net.n2oapp.platform.jaxrs.RemoteException;
import net.n2oapp.platform.jaxrs.RestException;
import net.n2oapp.platform.jaxrs.RestMessage;
import net.n2oapp.platform.jaxrs.RestPage;
import net.n2oapp.platform.jaxrs.api.AbstractModel;
import net.n2oapp.platform.jaxrs.api.AbstractModelMixin;
import net.n2oapp.platform.jaxrs.api.IntegerModel;
import net.n2oapp.platform.jaxrs.api.ListModel;
import net.n2oapp.platform.jaxrs.api.SomeCriteria;
import net.n2oapp.platform.jaxrs.api.SomeModel;
import net.n2oapp.platform.jaxrs.api.SomeRest;
import net.n2oapp.platform.jaxrs.api.StringModel;
import net.n2oapp.platform.jaxrs.impl.SomeRestImpl;
import net.n2oapp.platform.jaxrs.seek.RequestedPageEnum;
import net.n2oapp.platform.jaxrs.seek.SeekRequest;
import net.n2oapp.platform.jaxrs.seek.SeekedPage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.ReflectionUtils;

@SpringBootApplication
@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={JaxRsClientTest.class}, webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT, properties={"server.port=8423", "n2o.ui.message.stacktrace=true"})
public class JaxRsClientTest {
    @Autowired
    @Qualifier(value="someRestJaxRsProxyClient")
    private SomeRest client;

    @Test
    public void pagingAndFiltering() {
        this.forEachHeaderCombination(() -> {
            SomeCriteria criteria = new SomeCriteria(2, 20);
            criteria.setLikeName("John");
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            criteria.setDateBegin(df.parse("01.01.2018 01:00"));
            Page<SomeModel> page = this.client.search(criteria);
            MatcherAssert.assertThat((Object)page.getTotalElements(), (Matcher)CoreMatchers.equalTo((Object)100L));
            MatcherAssert.assertThat((Object)page.getContent().size(), (Matcher)CoreMatchers.equalTo((Object)20));
            MatcherAssert.assertThat((Object)((SomeModel)page.getContent().get(0)).getId(), (Matcher)CoreMatchers.equalTo((Object)40L));
            MatcherAssert.assertThat((Object)((SomeModel)page.getContent().get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)"John"));
            MatcherAssert.assertThat((Object)((SomeModel)page.getContent().get(0)).getDate(), (Matcher)CoreMatchers.equalTo((Object)df.parse("01.01.2018 01:00")));
            Method[] declaredMethods = page.getClass().getDeclaredMethods();
            RestPage expectedPage = new RestPage(page.getContent(), (Pageable)criteria, page.getTotalElements());
            expectedPage.setTotalElements(page.getTotalElements());
            StringBuilder expectedStringOfValues = new StringBuilder();
            StringBuilder actualStringOfValues = new StringBuilder();
            for (Method method : declaredMethods) {
                if (!method.getName().startsWith("get") || method.getParameterCount() != 0) continue;
                expectedStringOfValues.append(method.invoke((Object)expectedPage, new Object[0]));
                actualStringOfValues.append(method.invoke(page, new Object[0]));
            }
            MatcherAssert.assertThat((Object)actualStringOfValues.toString(), (Matcher)CoreMatchers.equalTo((Object)expectedStringOfValues.toString()));
        });
    }

    @Test
    public void sort() {
        this.forEachHeaderCombination(() -> {
            SomeCriteria criteria = new SomeCriteria(1, 10, Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "name"), new Sort.Order(Sort.Direction.DESC, "date")}));
            Page<SomeModel> page = this.client.search(criteria);
            MatcherAssert.assertThat((Object)page.getSort(), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)page.getSort().getOrderFor("name").getDirection(), (Matcher)CoreMatchers.equalTo((Object)Sort.Direction.ASC));
            MatcherAssert.assertThat((Object)page.getSort().getOrderFor("date").getDirection(), (Matcher)CoreMatchers.equalTo((Object)Sort.Direction.DESC));
        });
    }

    @Test
    public void validations() {
        this.forEachHeaderCombination(() -> {
            SomeModel model = new SomeModel();
            model.setStringModel(new StringModel(null));
            try {
                this.client.create(model);
                Assert.fail();
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RestException.class));
                RestException restException = (RestException)e;
                MatcherAssert.assertThat((Object)restException.getErrors().size(), (Matcher)CoreMatchers.equalTo((Object)4));
                for (RestMessage.BaseError error : restException.getErrors()) {
                    MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.instanceOf(RestMessage.ConstraintViolationError.class));
                    RestMessage.ConstraintViolationError constraintViolationError = (RestMessage.ConstraintViolationError)error;
                    Assert.assertNotNull((Object)constraintViolationError.getConstraintAnnotation());
                    Assert.assertTrue((SomeModel.class.getName().equals(constraintViolationError.getLeafBeanClass()) || StringModel.class.getName().equals(constraintViolationError.getLeafBeanClass()) ? 1 : 0) != 0);
                    Assert.assertEquals((Object)"javax.validation.constraints.NotNull", (Object)constraintViolationError.getConstraintAnnotation());
                }
            }
        });
    }

    @Test
    public void exceptions() {
        this.forEachHeaderCombination(() -> {
            try {
                this.client.update(new SomeModel());
                Assert.fail();
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RestException.class));
                RestException restException = (RestException)e;
                Assert.assertNotNull((Object)restException.getMessage());
                MatcherAssert.assertThat((Object)restException.getCause(), (Matcher)CoreMatchers.instanceOf(RemoteException.class));
                MatcherAssert.assertThat((Object)restException.getCause().getMessage(), (Matcher)CoreMatchers.is((Object)"java.lang.IllegalArgumentException: Field [id] mustn't be null"));
                Optional<StackTraceElement> causeLine = Stream.of(restException.getCause().getStackTrace()).filter(ste -> ste.getMethodName().equals("update") && ste.getClassName().equals(SomeRestImpl.class.getName()) && (SomeRestImpl.class.getSimpleName() + ".java").equals(ste.getFileName()) && ste.getLineNumber() > 0).findAny();
                MatcherAssert.assertThat((Object)causeLine.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            }
        });
    }

    @Test
    public void i18n() {
        this.forEachHeaderCombination(() -> {
            try {
                this.client.update(new SomeModel(-1L));
                Assert.fail();
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RestException.class));
                RestException restException = (RestException)e;
                MatcherAssert.assertThat((Object)restException.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 -1 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c"), CoreMatchers.is((Object)"example.idPositive")}));
            }
        });
    }

    @Test
    public void pageOfAbstractModel() {
        this.forEachHeaderCombination(() -> MatcherAssert.assertThat(this.client.searchModel(new SomeCriteria()).getContent().get(0), (Matcher)CoreMatchers.instanceOf(StringModel.class)));
    }

    @Test
    public void userExceptionsWithMessageList() {
        this.forEachHeaderCombination(() -> {
            try {
                this.client.throwErrors();
                Assert.fail();
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RestException.class));
                RestException restException = (RestException)e;
                MatcherAssert.assertThat((Object)restException.getErrors().size(), (Matcher)CoreMatchers.equalTo((Object)3));
                List errorTextList = restException.getErrors().stream().map(RestMessage.BaseError::getMessage).collect(Collectors.toList());
                MatcherAssert.assertThat(errorTextList, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.hasItems((Object[])new String[]{"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0440\u0430\u0437", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u0432\u0430", "\u0414\u0440\u0443\u0433\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"}), CoreMatchers.hasItems((Object[])new String[]{"user.error1", "user.error1", "user.error2"})}));
            }
        });
    }

    @Test
    public void testSearchByList() {
        this.forEachHeaderCombination(() -> {
            List<LocalDateTime> expectedList = Arrays.asList(LocalDateTime.now(), LocalDateTime.now().minusDays(2L));
            List<LocalDateTime> actual = this.client.searchBySetOfTypedList(CollectionUtil.setOf(expectedList));
            Assert.assertEquals(expectedList, actual);
        });
    }

    @Test
    public void testSearchByMap() {
        this.forEachHeaderCombination(() -> {
            Map<String, String> expectedMap = CollectionUtil.mapOf("key1", "value1", "key2", "value2");
            Map<String, String> actual = this.client.searchBySetOfTypedMap(expectedMap);
            Assert.assertEquals(expectedMap, actual);
        });
    }

    @Test
    public void testGetListOfAbstractModels() {
        this.forEachHeaderCombination(() -> {
            List<AbstractModel<?>> listOfAbstractModels = this.client.getListOfAbstractModels();
            MatcherAssert.assertThat((Object)listOfAbstractModels.size(), (Matcher)CoreMatchers.equalTo((Object)2));
            MatcherAssert.assertThat(listOfAbstractModels.get(0).getClass(), (Matcher)CoreMatchers.equalTo(StringModel.class));
            MatcherAssert.assertThat(listOfAbstractModels.get(1).getClass(), (Matcher)CoreMatchers.equalTo(IntegerModel.class));
        });
    }

    @Test
    public void testGetListModels() {
        this.forEachHeaderCombination(() -> {
            List<ListModel> genericList = this.client.getListModels();
            int i = 0;
            for (ListModel model : genericList) {
                for (Object obj : (List)model.getValue()) {
                    MatcherAssert.assertThat(obj.getClass(), (Matcher)CoreMatchers.equalTo(IntegerModel.class));
                    MatcherAssert.assertThat(((IntegerModel)obj).getValue(), (Matcher)CoreMatchers.equalTo((Object)i++));
                }
            }
        });
    }

    @Test
    public void testSeek() {
        this.forEachHeaderCombination(() -> {
            SeekRequest request = new SeekRequest();
            request.setPivots(SomeRestImpl.EXPECTED_PIVOTS);
            request.setPage(RequestedPageEnum.NEXT);
            request.setSize(Integer.valueOf(1000));
            request.setSort(Sort.by(CollectionUtil.listOf(Sort.Order.asc((String)"id"), Sort.Order.desc((String)"name"))));
            SeekedPage<String> page = this.client.searchSeeking(request);
            MatcherAssert.assertThat((Object)page.getContent(), (Matcher)CoreMatchers.is(CollectionUtil.listOf("ok!")));
            MatcherAssert.assertThat((Object)page.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)page.hasPrev(), (Matcher)CoreMatchers.is((Object)false));
            request.setSort(Sort.unsorted());
            this.client.searchSeeking(request);
        });
    }

    private void forEachHeaderCombination(ExceptionalRunnable run) {
        ReflectionUtils.doWithMethods(this.client.getClass(), method -> {
            for (Map<String, String> params : Application.HEADERS) {
                try {
                    method.invoke((Object)this.client, new MultivaluedHashMap(params));
                    try {
                        run.run();
                    }
                    catch (Exception e) {
                        System.out.println("ERROR AT SUCH HEADERS: " + params);
                        throw e;
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("InvocationTargetException", e);
                }
            }
        }, method -> method.getName().equals("headers"));
    }

    @Configuration
    public static class JaxRsClientTestConfig {
        @Bean
        public MapperConfigurer mapperPreparer() {
            return mapper -> {
                mapper.addMixIn(AbstractModel.class, AbstractModelMixin.class);
                mapper.writerFor((TypeReference)new TypeReference<PageImpl<AbstractModel>>(){});
            };
        }
    }

    private static interface ExceptionalRunnable {
        public void run() throws Exception;
    }
}

