/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.net.SocketTimeoutException;
import net.n2oapp.platform.jaxrs.Application;
import net.n2oapp.platform.jaxrs.api.SomeRest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.SocketUtils;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Application.class}, properties={"cxf.servlet.init.service-list-path=/info", "cxf.path=/test/api", "cxf.jaxrs.component-scan=true", "cxf.jaxrs.client.classes-scan=true", "cxf.jaxrs.client.classes-scan-packages=net.n2oapp.platform.jaxrs.api", "cxf.jaxrs.client.address=http://localhost:${server.port}/test/api", "cxf.jaxrs.client.receive.timeout=1000"}, webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
public class DefineReceiveTimeoutTest {
    @Autowired
    @Qualifier(value="someRestJaxRsProxyClient")
    private SomeRest client;

    @BeforeClass
    public static void init() {
        System.setProperty("server.port", String.valueOf(SocketUtils.findAvailableTcpPort()));
    }

    @AfterClass
    public static void destroy() {
        System.clearProperty("server.port");
    }

    @Test
    public void testReceiveTimeoutSuccess() throws InterruptedException {
        Assert.assertEquals((Object)"timeout success", (Object)this.client.timeoutSuccess());
    }

    @Test
    public void testReceiveTimeoutFail() {
        long start = System.currentTimeMillis();
        try {
            this.client.timeoutFailure();
            Assert.fail((String)"receive timeout exception is expected");
        }
        catch (Exception e) {
            long end = System.currentTimeMillis();
            Assert.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
            Assert.assertTrue((String)"timeout must be approximately 1 sec", (end - start >= 1000L ? 1 : 0) != 0);
            Assert.assertTrue((String)"margin of error less than 1 sec", (end - start < 2000L ? 1 : 0) != 0);
        }
    }
}

