/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.lang.reflect.Field;
import net.n2oapp.platform.jaxrs.Application;
import org.apache.cxf.ext.logging.AbstractLoggingInterceptor;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrettyLoggingFilter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Application.class}, properties={"jaxrs.logging-in.enabled=true", "jaxrs.logging-in.limit=1024", "jaxrs.logging-in.in-mem-threshold=102400", "jaxrs.logging-in.log-binary=true", "jaxrs.logging-in.log-multipart=true", "jaxrs.logging-in.pretty-logging=true"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class DefineLoggingAttributesTest {
    static final int LIMIT = 1024;
    static final int IN_MEM_THRESHOLD = 102400;
    static final boolean LOG_BINARY = true;
    static final boolean LOG_MULTIPART = true;
    static final boolean PRETTY_LOGGING = true;
    @Autowired
    private LoggingInInterceptor loggingInInterceptor;

    @Test
    public void testLimit() {
        Assert.assertEquals((long)1024L, (long)this.loggingInInterceptor.getLimit());
    }

    @Test
    public void testInMemThreshold() {
        Assert.assertEquals((long)102400L, (long)this.loggingInInterceptor.getInMemThreshold());
    }

    @Test
    public void testLogBinary() throws NoSuchFieldException, IllegalAccessException {
        Field privateLogBinaryField = AbstractLoggingInterceptor.class.getDeclaredField("logBinary");
        privateLogBinaryField.setAccessible(true);
        Assert.assertEquals((Object)true, (Object)privateLogBinaryField.get(this.loggingInInterceptor));
    }

    @Test
    public void testLogMultipart() throws NoSuchFieldException, IllegalAccessException {
        Field privateLogMultipartField = AbstractLoggingInterceptor.class.getDeclaredField("logMultipart");
        privateLogMultipartField.setAccessible(true);
        Assert.assertEquals((Object)true, (Object)privateLogMultipartField.get(this.loggingInInterceptor));
    }

    @Test
    public void testPrettyLogging() throws NoSuchFieldException, IllegalAccessException {
        Field privateSenderField = AbstractLoggingInterceptor.class.getDeclaredField("sender");
        privateSenderField.setAccessible(true);
        LogEventSender sender = (LogEventSender)privateSenderField.get(this.loggingInInterceptor);
        if (sender instanceof PrettyLoggingFilter) {
            Field privatePrettyField = PrettyLoggingFilter.class.getDeclaredField("prettyLogging");
            privatePrettyField.setAccessible(true);
            Assert.assertEquals((Object)true, (Object)privatePrettyField.get(sender));
        }
    }
}

