/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.net.SocketTimeoutException;
import net.n2oapp.platform.jaxrs.Application;
import net.n2oapp.platform.jaxrs.api.SomeRest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Application.class}, properties={"cxf.servlet.init.service-list-path=/info", "cxf.path=/test/api", "cxf.jaxrs.component-scan=true", "cxf.jaxrs.client.classes-scan=true", "cxf.jaxrs.client.classes-scan-packages=net.n2oapp.platform.jaxrs.api", "cxf.jaxrs.client.address=http://10.10.10.10:1010/test/api", "cxf.jaxrs.client.connection.timeout=1000"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class DefineConnectionTimeoutTest {
    @Autowired
    @Qualifier(value="someRestJaxRsProxyClient")
    private SomeRest client;

    @Test
    public void testConnectionTimeoutFail() {
        long start = System.currentTimeMillis();
        try {
            this.client.timeoutSuccess();
            Assert.fail((String)"connection timeout exception is expected");
        }
        catch (Exception e) {
            long end = System.currentTimeMillis();
            Assert.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
            Assert.assertTrue((String)"timeout must be approximately 1 sec", (end - start >= 1000L ? 1 : 0) != 0);
            Assert.assertTrue((String)"margin of error less than 1 sec", (end - start < 2000L ? 1 : 0) != 0);
        }
    }
}

