/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.autoconfig;

import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@AutoConfiguration
@AutoConfigureAfter(value={LiquibaseAutoConfiguration.class})
public class DbAuditLiquibaseConfiguration {
    private final DataSource dataSource;

    @Autowired
    public DbAuditLiquibaseConfiguration(ObjectProvider<DataSource> dataSource) {
        this.dataSource = (DataSource)dataSource.getIfUnique();
    }

    @Bean(name={"liquibase"})
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    public void liquibase() {
    }

    @Bean(name={"auditLiquibase"})
    @DependsOn(value={"liquibase"})
    public SpringLiquibase auditLiquibase() {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(this.dataSource);
        liquibase.setChangeLog("classpath:/db/changelog/audit-changelog.yaml");
        return liquibase;
    }
}

