/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.admin.sso.keycloak;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import net.n2oapp.security.admin.sso.keycloak.AdminSsoKeycloakProperties;
import net.n2oapp.security.admin.sso.keycloak.KeycloakRestRoleService;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;

public class KeycloakRestUserService {
    private static String USER_BY_ID = "%s/admin/realms/%s/users/%s";
    private static String USERS = "%s/admin/realms/%s/users/";
    private static String USER_ROLES = "%s/admin/realms/%s/users/%s/role-mappings/realm";
    private static String EMAIL_ACTIONS = "%s/admin/realms/%s/users/%s/execute-actions-email";
    private static String RESET_PASSWORD = "%s/admin/realms/%s/users/%s/reset-password";
    private static String SEARCH_USERS = "%s/admin/realms/%s/users%s";
    private static String USERS_COUNT = "%s/admin/realms/%s/users/count";
    private AdminSsoKeycloakProperties properties;
    private RestClient restClient;
    private KeycloakRestRoleService roleService;

    public KeycloakRestUserService(AdminSsoKeycloakProperties properties, RestClient restClient, KeycloakRestRoleService roleService) {
        this.properties = properties;
        this.restClient = restClient;
        this.roleService = roleService;
    }

    public Integer getUsersCount() {
        String serverUrl = String.format(USERS_COUNT, this.properties.getServerUrl(), this.properties.getRealm());
        try {
            return (Integer)this.restClient.get().uri(serverUrl, new Object[0]).retrieve().body(Integer.class);
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().value() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserRepresentation getById(String userGuid) {
        String serverUrl = String.format(USER_BY_ID, this.properties.getServerUrl(), this.properties.getRealm(), userGuid);
        try {
            ResponseEntity response = this.restClient.get().uri(serverUrl, new Object[0]).retrieve().toEntity(UserRepresentation.class);
            return (UserRepresentation)response.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().value() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public List<UserRepresentation> searchUsers(String search, Integer first, Integer max) {
        Object criteria;
        Object object = criteria = first == null ? "" : "first=" + first;
        if (max != null) {
            criteria = (String)criteria + (((String)criteria).isEmpty() ? "max=" + max : "&max=" + max);
        }
        if (search != null && !search.isEmpty()) {
            criteria = (String)criteria + (((String)criteria).isEmpty() ? "search=" + search : "&search=" + search);
        }
        String serverUrl = String.format(SEARCH_USERS, this.properties.getServerUrl(), this.properties.getRealm(), ((String)criteria).isEmpty() ? "" : "?" + (String)criteria);
        try {
            ResponseEntity response = this.restClient.get().uri(serverUrl, new Object[0]).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<List<UserRepresentation>>(this){});
            return (List)response.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().value() == 404) {
                return Collections.EMPTY_LIST;
            }
            throw ex;
        }
    }

    public String createUser(UserRepresentation user) {
        String serverUrl = String.format(USERS, this.properties.getServerUrl(), this.properties.getRealm());
        ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.post().uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)user).retrieve().toEntity(Response.class);
        if (response.getStatusCode().value() >= 200 && response.getStatusCode().value() < 300) {
            return response.getHeaders().getLocation().getPath().replaceAll(".*/([^/]+)$", "$1");
        }
        throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
    }

    public void updateUser(UserRepresentation user) {
        String serverUrl = String.format(USER_BY_ID, this.properties.getServerUrl(), this.properties.getRealm(), user.getId());
        ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.put().uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)user).retrieve().toEntity(Response.class);
        if (response.getStatusCode().value() < 200 || response.getStatusCode().value() > 300) {
            throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
    }

    public void deleteUser(String guid) {
        String serverUrl = String.format(USER_BY_ID, this.properties.getServerUrl(), this.properties.getRealm(), guid);
        ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.method(HttpMethod.DELETE).uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).retrieve().toEntity(Response.class);
        if (response.getStatusCode().value() < 200 || response.getStatusCode().value() > 300) {
            throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
    }

    public void addUserRoles(String userGuid, List<RoleRepresentation> roles) {
        if (roles != null && !roles.isEmpty()) {
            roles.forEach(r -> {
                if (r.getId() == null) {
                    RoleRepresentation byName = this.roleService.getByName(r.getName());
                    if (byName == null) {
                        String newRoleId = this.roleService.createRole((RoleRepresentation)r);
                        r.setId(newRoleId);
                    } else {
                        r.setId(byName.getId());
                    }
                }
            });
            String serverUrl = String.format(USER_ROLES, this.properties.getServerUrl(), this.properties.getRealm(), userGuid);
            ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.post().uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(roles).retrieve().toEntity(Response.class);
            if (response.getStatusCode().value() < 200 || response.getStatusCode().value() > 300) {
                throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
            }
        }
    }

    public List<RoleRepresentation> getActualUserRoles(String userGuid) {
        String serverUrl = String.format(USER_ROLES, this.properties.getServerUrl(), this.properties.getRealm(), userGuid);
        try {
            ResponseEntity response = this.restClient.get().uri(serverUrl, new Object[0]).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<List<RoleRepresentation>>(this){});
            return (List)response.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().value() == 404) {
                return Collections.EMPTY_LIST;
            }
            throw ex;
        }
    }

    public void deleteUserRoles(String userGuid, List<RoleRepresentation> roles) {
        if (roles != null && !roles.isEmpty()) {
            String serverUrl = String.format(USER_ROLES, this.properties.getServerUrl(), this.properties.getRealm(), userGuid);
            ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.method(HttpMethod.DELETE).uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(roles).retrieve().toEntity(Response.class);
            if (response.getStatusCode().value() < 200 || response.getStatusCode().value() > 300) {
                throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
            }
        }
    }

    public void changePassword(String userGuid, String newPassword) {
        CredentialRepresentation passwordCred = new CredentialRepresentation();
        passwordCred.setTemporary(Boolean.valueOf(false));
        passwordCred.setType("password");
        passwordCred.setValue(newPassword);
        String serverUrl = String.format(RESET_PASSWORD, this.properties.getServerUrl(), this.properties.getRealm(), userGuid);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.put().uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)passwordCred).retrieve().toEntity(Response.class);
        if (response.getStatusCode().value() < 200 || response.getStatusCode().value() > 300) {
            throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

