/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.admin.sso.keycloak;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.n2oapp.security.admin.sso.keycloak.AdminSsoKeycloakProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;

public class KeycloakRestRoleService {
    private static final Logger log = LogManager.getLogger(KeycloakRestRoleService.class);
    private static String ROLE_BY_NAME = "%s/admin/realms/%s/roles/%s";
    private static String ROLES = "%s/admin/realms/%s/roles/";
    private static String ROLE_COMPOSITES = "%s/admin/realms/%s/roles/%s/composites";
    private AdminSsoKeycloakProperties properties;
    private WebClient webClient;

    public KeycloakRestRoleService(AdminSsoKeycloakProperties properties, WebClient webClient) {
        this.properties = properties;
        this.webClient = webClient;
    }

    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public RoleRepresentation getByName(String roleName) {
        String serverUrl = String.format(ROLE_BY_NAME, this.properties.getServerUrl(), this.properties.getRealm(), roleName);
        try {
            ResponseEntity response = (ResponseEntity)this.webClient.get().uri(serverUrl, new Object[0]).retrieve().toEntity(RoleRepresentation.class).block();
            return (RoleRepresentation)response.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getRawStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public List<RoleRepresentation> getAllRoles() {
        String serverUrl = String.format(ROLES, this.properties.getServerUrl(), this.properties.getRealm());
        try {
            ResponseEntity response = (ResponseEntity)this.webClient.get().uri(serverUrl, new Object[0]).retrieve().toEntityList(RoleRepresentation.class).block();
            return (List)response.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getRawStatusCode() == 404) {
                return Collections.emptyList();
            }
            throw ex;
        }
    }

    public String createRole(RoleRepresentation role) {
        ResponseEntity response;
        String serverUrl = String.format(ROLES, this.properties.getServerUrl(), this.properties.getRealm());
        String roleCompositesServerUrl = String.format(ROLE_COMPOSITES, this.properties.getServerUrl(), this.properties.getRealm(), role.getName());
        try {
            response = (ResponseEntity)((WebClient.RequestBodySpec)this.webClient.post().uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)role).retrieve().toEntity(Response.class).block();
        }
        catch (WebClientResponseException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.CONFLICT)) {
                log.warn(String.format("Role with id:'%s' already exists in keycloak:'%s'", role.getName(), this.properties.getServerUrl()));
                return role.getName();
            }
            throw e;
        }
        if (response.getStatusCodeValue() >= 200 && response.getStatusCodeValue() < 300) {
            if (role.getComposites() != null) {
                ResponseEntity compositesResponse;
                HashSet composites = new HashSet();
                if (role.getComposites().getRealm() != null) {
                    composites.addAll(role.getComposites().getRealm().stream().map(IdObject::new).collect(Collectors.toSet()));
                }
                if (role.getComposites().getClient() != null) {
                    composites.addAll(role.getComposites().getClient().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).map(IdObject::new).collect(Collectors.toSet()));
                }
                if ((compositesResponse = (ResponseEntity)((WebClient.RequestBodySpec)this.webClient.post().uri(roleCompositesServerUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue(composites).retrieve().toEntity(Response.class).block()).getStatusCodeValue() < 200 || compositesResponse.getStatusCodeValue() > 300) {
                    throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
                }
            }
            return this.getByName(role.getName()).getId();
        }
        throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
    }

    public void updateRole(RoleRepresentation role) {
        String serverUrl = String.format(ROLE_BY_NAME, this.properties.getServerUrl(), this.properties.getRealm(), role.getName());
        String roleCompositesServerUrl = String.format(ROLE_COMPOSITES, this.properties.getServerUrl(), this.properties.getRealm(), role.getName());
        ResponseEntity response = (ResponseEntity)((WebClient.RequestBodySpec)this.webClient.put().uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)role).retrieve().toEntity(Response.class).block();
        if (response.getStatusCodeValue() < 200 || response.getStatusCodeValue() > 300) {
            throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
        if (response.getStatusCodeValue() >= 200 && response.getStatusCodeValue() < 300) {
            if (role.isComposite()) {
                Set forRemove;
                List<RoleRepresentation> currentCompositesRes = this.getRoleComposites(role.getName());
                HashSet<String> currentComposites = new HashSet<String>();
                for (RoleRepresentation r2 : currentCompositesRes) {
                    currentComposites.add(r2.getId());
                }
                if (role.getComposites() == null) {
                    forRemove = currentComposites.stream().map(IdObject::new).collect(Collectors.toSet());
                } else {
                    ResponseEntity compositesResponse;
                    HashSet composites = new HashSet();
                    if (role.getComposites().getRealm() != null) {
                        composites.addAll(role.getComposites().getRealm());
                    }
                    if (role.getComposites().getClient() != null) {
                        composites.addAll(role.getComposites().getClient().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()));
                    }
                    forRemove = currentComposites.stream().filter(r -> !composites.contains(r)).map(IdObject::new).collect(Collectors.toSet());
                    Set newComposites = composites.stream().filter(r -> !currentComposites.contains(r)).map(IdObject::new).collect(Collectors.toSet());
                    if (newComposites != null && ((compositesResponse = (ResponseEntity)((WebClient.RequestBodySpec)this.webClient.post().uri(roleCompositesServerUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue(newComposites).retrieve().toEntity(Response.class).block()).getStatusCodeValue() < 200 || compositesResponse.getStatusCodeValue() > 300)) {
                        throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
                    }
                }
                if (!forRemove.isEmpty()) {
                    ((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.DELETE).uri(roleCompositesServerUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue(forRemove).retrieve().toEntity(Response.class).block();
                }
            }
        } else {
            throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
    }

    public List<RoleRepresentation> getRoleComposites(String roleName) {
        String roleCompositesServerUrl = String.format(ROLE_COMPOSITES, this.properties.getServerUrl(), this.properties.getRealm(), roleName);
        return (List)((ResponseEntity)this.webClient.get().uri(roleCompositesServerUrl, new Object[0]).retrieve().toEntityList(RoleRepresentation.class).block()).getBody();
    }

    public void deleteRole(String roleName) {
        String serverUrl = String.format(ROLE_BY_NAME, this.properties.getServerUrl(), this.properties.getRealm(), roleName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        ResponseEntity response = (ResponseEntity)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.DELETE).uri(serverUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).retrieve().toEntity(Response.class).block();
        if (response.getStatusCodeValue() < 200 || response.getStatusCodeValue() > 300) {
            throw new IllegalArgumentException(((ErrorRepresentation)((Response)response.getBody()).readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
    }

    public static class IdObject {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public IdObject(String id) {
            this.id = id;
        }

        public IdObject() {
        }
    }
}

