/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.admin.sso.keycloak;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.platform.i18n.UserException;
import net.n2oapp.security.admin.api.model.Role;
import net.n2oapp.security.admin.api.model.SsoUser;
import net.n2oapp.security.admin.api.provider.SsoUserRoleProvider;
import net.n2oapp.security.admin.sso.keycloak.AdminSsoKeycloakProperties;
import net.n2oapp.security.admin.sso.keycloak.KeycloakRestRoleService;
import net.n2oapp.security.admin.sso.keycloak.KeycloakRestUserService;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpClientErrorException;

public class KeycloakSsoUserRoleProvider
implements SsoUserRoleProvider {
    public static final String EXT_SYS = "KEYCLOAK";
    private AdminSsoKeycloakProperties properties;
    @Autowired
    private KeycloakRestRoleService roleService;
    @Autowired
    private KeycloakRestUserService userService;
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    @Qualifier(value="cxfObjectMapper")
    public ObjectMapper objectMapper;

    public KeycloakSsoUserRoleProvider(AdminSsoKeycloakProperties properties) {
        this.properties = properties;
    }

    public boolean isSupports(String ssoName) {
        return ssoName == null || EXT_SYS.equalsIgnoreCase(ssoName);
    }

    public SsoUser createUser(SsoUser user) {
        UserRepresentation userRepresentation = this.map(user);
        if (!CollectionUtils.isEmpty((Collection)user.getRequiredActions())) {
            userRepresentation.setRequiredActions(user.getRequiredActions());
        }
        try {
            String userGuid = this.userService.createUser(userRepresentation);
            user.setExtUid(userGuid);
            user.setExtSys(EXT_SYS);
            if (user.getRoles() != null) {
                List<RoleRepresentation> roles = user.getRoles().stream().map(this::map).collect(Collectors.toList());
                this.userService.addUserRoles(userGuid, roles);
            }
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
        return user;
    }

    public void updateUser(SsoUser user) {
        UserRepresentation userRepresentation = this.map(user);
        try {
            this.userService.updateUser(userRepresentation);
            List<Object> forRemove = new ArrayList();
            if (user.getRoles() == null || user.getRoles().isEmpty()) {
                forRemove = this.userService.getActualUserRoles(user.getExtUid());
            } else {
                Set roleNames = user.getRoles().stream().map(Role::getCode).collect(Collectors.toSet());
                List<RoleRepresentation> effective = this.userService.getActualUserRoles(user.getExtUid());
                if (effective != null) {
                    forRemove = effective.stream().filter(e -> !roleNames.contains(e.getName())).collect(Collectors.toList());
                }
                HashSet effectiveRoleNames = effective == null ? new HashSet() : effective.stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
                this.userService.addUserRoles(user.getExtUid(), user.getRoles().stream().filter(r -> !effectiveRoleNames.contains(r.getCode())).map(this::map).collect(Collectors.toList()));
            }
            this.userService.deleteUserRoles(user.getExtUid(), forRemove);
            if (user.getPassword() != null) {
                this.userService.changePassword(user.getExtUid(), user.getPassword());
            }
        }
        catch (HttpClientErrorException e2) {
            this.throwUserException(e2);
        }
    }

    public void deleteUser(SsoUser user) {
        try {
            this.userService.deleteUser(user.getExtUid());
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
    }

    public void changeActivity(SsoUser user) {
        UserRepresentation userRepresentation = this.map(user);
        userRepresentation.setEnabled(user.getIsActive());
        try {
            this.userService.updateUser(userRepresentation);
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
    }

    public Role createRole(Role role) {
        try {
            this.roleService.createRole(this.map(role));
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
        return role;
    }

    public void updateRole(Role role) {
        try {
            this.roleService.updateRole(this.map(role));
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
    }

    public void deleteRole(Role role) {
        try {
            this.roleService.deleteRole(role.getCode());
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
    }

    public void resetPassword(SsoUser user) {
        UserRepresentation userRepresentation = this.map(user);
        if (!CollectionUtils.isEmpty((Collection)user.getRequiredActions())) {
            userRepresentation.setRequiredActions(user.getRequiredActions());
        }
        try {
            this.userService.updateUser(userRepresentation);
        }
        catch (HttpClientErrorException e) {
            this.throwUserException(e);
        }
    }

    public void startSynchronization() {
        try {
            this.schedulerFactoryBean.getScheduler().triggerJob(new JobKey("User_Synchronize_Job_Detail"));
        }
        catch (SchedulerException e) {
            throw new UserException("exception.failedSyncStart", (Throwable)e);
        }
    }

    private void throwUserException(HttpClientErrorException exception) {
        try {
            Map map = (Map)this.objectMapper.readValue(exception.getResponseBodyAsString(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String errorMessage = map.containsKey("errorMessage") ? (String)map.get("errorMessage") : (String)map.get("error");
            throw new UserException("exception." + errorMessage.toLowerCase().replace(" ", "-"), (Throwable)exception);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(exception);
        }
    }

    private UserRepresentation map(SsoUser user) {
        UserRepresentation kUser = new UserRepresentation();
        kUser.setId(user.getExtUid());
        kUser.setEnabled(user.getIsActive());
        kUser.setUsername(user.getUsername() != null ? user.getUsername() : "");
        kUser.setFirstName(user.getName() != null ? user.getName() : "");
        kUser.setLastName(user.getSurname() != null ? user.getSurname() : "");
        kUser.setEmail(user.getEmail() != null ? user.getEmail() : "");
        kUser.setEmailVerified(this.properties.getEmailVerified());
        if (user.getPassword() != null) {
            CredentialRepresentation passwordCred = new CredentialRepresentation();
            passwordCred.setTemporary(this.properties.getTemporaryPassword());
            passwordCred.setType("password");
            passwordCred.setValue(user.getPassword());
            kUser.setCredentials(Arrays.asList(passwordCred));
        }
        return kUser;
    }

    private RoleRepresentation map(Role role) {
        RoleRepresentation res = new RoleRepresentation();
        res.setName(role.getCode());
        res.setComposite(false);
        res.setDescription(role.getDescription());
        return res;
    }

    public void setRoleService(KeycloakRestRoleService roleService) {
        this.roleService = roleService;
    }

    public void setUserService(KeycloakRestUserService userService) {
        this.userService = userService;
    }
}

