/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.view.operations;

import com.sun.istack.NotNull;
import java.util.function.Supplier;
import net.n2oapp.cache.template.CacheTemplate;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.event.MetadataChangeListener;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.PipelineOperationTypeAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperation;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationTypeEnum;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.api.register.SourceInfo;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SandboxSourceCacheOperation<S extends SourceMetadata>
extends MetadataChangeListener
implements PipelineOperation<S, S>,
PipelineOperationTypeAware,
MetadataEnvironmentAware {
    public static final String CACHE_REGION = "n2o.source";
    private final CacheTemplate<String, S> cacheTemplate;
    private MetadataRegister metadataRegister;
    private final String projectId;

    public SandboxSourceCacheOperation(@NotNull String projectId, CacheManager cacheManager) {
        this.cacheTemplate = new CacheTemplate(cacheManager);
        this.projectId = projectId;
    }

    public SandboxSourceCacheOperation(@NotNull String projectId, CacheTemplate<String, S> cacheTemplate, MetadataRegister metadataRegister) {
        this.cacheTemplate = cacheTemplate;
        this.metadataRegister = metadataRegister;
        this.projectId = projectId;
    }

    public PipelineOperationTypeEnum getPipelineOperationType() {
        return PipelineOperationTypeEnum.SOURCE_CACHE;
    }

    public S execute(CompileContext<?, ?> context, DataSet data, Supplier<S> supplier, CompileProcessor compileProcessor, BindProcessor bindProcessor, SourceProcessor sourceProcessor) {
        String sourceId = context.getSourceId(bindProcessor);
        SourceInfo info = this.metadataRegister.get(sourceId, context.getSourceClass());
        String key = this.getKey(sourceId, info.getBaseSourceClass());
        return (S)((SourceMetadata)this.cacheTemplate.execute(CACHE_REGION, (Object)key, supplier::get));
    }

    public void handleAllMetadataChange() {
        CacheManager cacheManager = this.cacheTemplate.getCacheManager();
        if (cacheManager == null) {
            return;
        }
        Cache cache = cacheManager.getCache(CACHE_REGION);
        if (cache == null) {
            return;
        }
        cache.clear();
    }

    public void handleMetadataChange(String id, Class<? extends SourceMetadata> sourceClass) {
        CacheManager cacheManager = this.cacheTemplate.getCacheManager();
        if (cacheManager == null) {
            return;
        }
        Cache cache = cacheManager.getCache(CACHE_REGION);
        if (cache == null) {
            return;
        }
        cache.evict((Object)this.getKey(id, sourceClass));
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.metadataRegister = environment.getMetadataRegister();
    }

    private String getKey(String id, Class<? extends SourceMetadata> sourceClass) {
        return this.projectId + "." + id + "." + sourceClass.getSimpleName();
    }
}

