/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.templates;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.sandbox.templates.CategoryModel;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ProjectTemplateHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectTemplateHolder.class);
    @Value(value="${n2o.sandbox.template-categories:/menu/examples.json,/menu/uxcomponents.json,/menu/interactions.json,/menu/uxcases.json,/menu/versions.json,/menu/applications.json}")
    private List<String> templateCategories;
    private List<CategoryModel> categoryModels = null;

    public List<CategoryModel> getProjectTemplates() {
        if (this.categoryModels == null) {
            this.loadTemplates();
        }
        return this.categoryModels;
    }

    public TemplateModel getTemplateModel(String projectId) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return null;
        }
        return this.categoryModels.stream().flatMap(cm -> cm.getSections().stream()).flatMap(sn -> sn.getTemplates().stream()).filter(te -> projectId.equals(te.getProjectId())).findAny().orElse(null);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    private void loadTemplates() {
        if (this.categoryModels == null) {
            this.categoryModels = new ArrayList<CategoryModel>();
            ObjectMapper objectMapper = new ObjectMapper();
            for (String category : this.templateCategories) {
                ClassPathResource resource = new ClassPathResource(category);
                try {
                    this.categoryModels.add((CategoryModel)objectMapper.readValue(resource.getInputStream(), objectMapper.getTypeFactory().constructType(CategoryModel.class)));
                }
                catch (IOException e) {
                    log.error("error while template loading {}", (Object)category, (Object)e);
                }
            }
        }
    }
}

