/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.templates;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.n2oapp.framework.sandbox.file_storage.model.ProjectModel;
import net.n2oapp.framework.sandbox.templates.CategoryModel;
import net.n2oapp.framework.sandbox.templates.GitLabDiffService;
import net.n2oapp.framework.sandbox.templates.LocalGitDiffService;
import net.n2oapp.framework.sandbox.templates.ProjectSearcher;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.ProjectsDiffResponse;
import net.n2oapp.framework.sandbox.templates.SearchProjectModel;
import net.n2oapp.framework.sandbox.templates.SectionModel;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import net.n2oapp.framework.sandbox.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProjectTemplateController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectTemplateController.class);
    private Logger logger = LoggerFactory.getLogger(ProjectTemplateController.class);
    @Autowired
    private ProjectTemplateHolder templatesHolder;
    @Autowired
    private ProjectSearcher projectSearcher;
    @Autowired
    private GitLabDiffService gitLabDiffService;

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/project"})
    public List<CategoryModel> getProjectTemplates() {
        return this.templatesHolder.getProjectTemplates();
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/project/{projectId}"})
    public ProjectModel getProject(@PathVariable(value="projectId") String projectId) {
        TemplateModel templateModel = this.templatesHolder.getTemplateModel(projectId);
        if (templateModel == null) {
            return null;
        }
        ProjectModel project = new ProjectModel();
        project.setId(projectId);
        project.setFiles(FileUtil.findResources(templateModel.getTemplateId()));
        project.setName(templateModel.getName());
        return project;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/project/search"})
    public List<SearchProjectModel> searchProjectMatches(@RequestParam(name="q") String text) throws URISyntaxException, IOException {
        return this.projectSearcher.search(text);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/projects-diff"})
    public ProjectsDiffResponse getNewProjectFiles(@RequestParam(name="oldTag") String oldTag, @RequestParam(name="newTag") String newTag) {
        String resourcesPath = "backend/n2o/n2o-sandbox/src/main/resources";
        try {
            List<String> allNewFiles;
            List<String> allOldFiles;
            File gitRoot = ProjectTemplateController.findGitRoot(new File("."));
            HashSet<String> changedPackages = new HashSet<String>();
            HashSet<String> maybeDeletedPackages = new HashSet<String>();
            boolean anyUpdated = false;
            boolean anyDeleted = false;
            if (gitRoot == null) {
                this.logger.info("Git root not found, using gitlab diff");
                this.gitLabDiffService.collectChangedPackages(resourcesPath, oldTag, newTag, maybeDeletedPackages, changedPackages);
                this.logger.info("Get all old files");
                allOldFiles = this.gitLabDiffService.listFilesAtTag(oldTag, resourcesPath);
                this.logger.info("Get all new files");
                allNewFiles = this.gitLabDiffService.listFilesAtTag(newTag, resourcesPath);
            } else {
                LocalGitDiffService.collectChangedPackagesFromPackage(gitRoot, resourcesPath, oldTag, newTag, maybeDeletedPackages, changedPackages);
                allOldFiles = LocalGitDiffService.runGitCommand(gitRoot, "ls-tree", "-r", "--name-only", oldTag, "--", resourcesPath);
                allNewFiles = LocalGitDiffService.runGitCommand(gitRoot, "ls-tree", "-r", "--name-only", newTag, "--", resourcesPath);
            }
            for (String pkg : changedPackages) {
                if (!allOldFiles.stream().anyMatch(f -> f.contains(pkg))) continue;
                anyUpdated = true;
                break;
            }
            for (String pkg : maybeDeletedPackages) {
                if (!allNewFiles.stream().noneMatch(f -> f.contains(pkg))) continue;
                anyDeleted = true;
                break;
            }
            ProjectsDiffResponse response = new ProjectsDiffResponse();
            this.logger.info("Any Updated {} Any Deleted {}", (Object)anyUpdated, (Object)anyDeleted);
            if (anyUpdated || anyDeleted) {
                response.setReload(true);
                response.setProjects(this.getAllProjects());
            } else {
                response.setReload(false);
                HashMap<String, ProjectModel> projects = new HashMap<String, ProjectModel>();
                for (String pkg : changedPackages) {
                    ProjectModel project = new ProjectModel();
                    project.setId(pkg.replace('/', '_'));
                    project.setFiles(FileUtil.findResources(pkg));
                    projects.put(project.getId(), project);
                }
                response.setProjects(projects);
            }
            this.logger.info("Send response with {} projects", (Object)response.getProjects().size());
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute changed packages between tags '" + oldTag + "' and '" + newTag + "'", e);
        }
    }

    private Map<String, ProjectModel> getAllProjects() {
        HashMap<String, ProjectModel> projects = new HashMap<String, ProjectModel>();
        List<CategoryModel> templates = this.templatesHolder.getProjectTemplates();
        for (CategoryModel category : templates) {
            for (SectionModel section : category.getSections()) {
                for (TemplateModel template : section.getTemplates()) {
                    ProjectModel project = new ProjectModel();
                    project.setId(template.getProjectId());
                    project.setFiles(FileUtil.findResources(template.getTemplateId()));
                    project.setName(template.getName());
                    projects.put(template.getProjectId(), project);
                }
            }
        }
        return projects;
    }

    private static File findGitRoot(File start) {
        int maxLevels = 10;
        for (File current = start.getAbsoluteFile(); current != null && maxLevels-- > 0; current = current.getParentFile()) {
            File dotGit = new File(current, ".git");
            if (!dotGit.exists()) continue;
            return current;
        }
        return null;
    }
}

