/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.n2oapp.framework.sandbox.templates.SearchProjectModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Component;

@Component
public class ProjectSearcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectSearcher.class);
    private static final int PROJECT_LIMIT = 30;
    private static final int PROJECT_MATCHES_LIMIT = 10;
    @Value(value="${n2o.sandbox.project-search-folders:/examples,/data,/access,/routing,/cases,/uxcomponents,/uxcases}")
    private List<String> projectFolders;
    @Autowired
    private ResourceLoader resourceLoader;

    public List<SearchProjectModel> search(String text) throws URISyntaxException, IOException {
        LinkedHashMap<String, SearchProjectModel> projectsMap = new LinkedHashMap<String, SearchProjectModel>();
        block7: for (String folder : this.projectFolders) {
            Resource[] resources;
            block8: for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath*:" + folder + "/**")) {
                if (!resource.isReadable() || resource.getFilename().endsWith(".json")) continue;
                String projectId = this.getProjectId(resource.getURL().toString(), folder);
                if (!projectsMap.containsKey(projectId) && projectsMap.size() == 30) continue block7;
                if (projectsMap.containsKey(projectId) && ((SearchProjectModel)projectsMap.get(projectId)).getItems().size() == 10) continue;
                try (Stream<String> lines = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8)).lines();){
                    List<String> linesList = lines.toList();
                    for (int i = 0; i < linesList.size(); ++i) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)linesList.get(i), (CharSequence)text)) continue;
                        if (!projectsMap.containsKey(projectId)) {
                            projectsMap.put(projectId, new SearchProjectModel(projectId, new ArrayList<SearchProjectModel.Item>()));
                        }
                        ((SearchProjectModel)projectsMap.get(projectId)).getItems().add(new SearchProjectModel.Item(this.getFileName(resource), linesList.get(i).trim(), i + 1));
                        if (((SearchProjectModel)projectsMap.get(projectId)).getItems().size() != 10) continue;
                        continue block8;
                    }
                }
                catch (Exception e) {
                    log.error(String.format("Error while reading file: %s\\%s%n%s", folder, this.getFileName(resource), e.getMessage()));
                }
            }
        }
        return new ArrayList<SearchProjectModel>(projectsMap.values());
    }

    private String getProjectId(String file, String folder) {
        return file.substring(file.indexOf(folder) + 1, file.lastIndexOf("/")).replace("/", "_");
    }

    private String getFileName(Resource resource) throws IOException {
        return resource.getURL().toString().substring(resource.getURL().toString().lastIndexOf("/") + 1);
    }
}

