/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.templates;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GitLabDiffService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final HttpClient httpClient = HttpClient.newHttpClient();
    @Value(value="${gitlab.project.id:412}")
    private String projectId;
    @Value(value="${gitlab.api:https://git.i-novus.ru/api/v4}")
    private String gitlabApi;
    @Value(value="${gitlab.token}")
    private String token;

    public void collectChangedPackages(String resourcesPath, String oldTag, String newTag, Set<String> maybeDeletedPackages, Set<String> changedPackages) throws IOException, InterruptedException {
        String compareUrl = String.format("%s/projects/%s/repository/compare?from=%s&to=%s", this.gitlabApi, this.projectId, oldTag, newTag);
        JsonNode json = this.callApi(compareUrl);
        JsonNode diffs = json.get("diffs");
        if (diffs == null) {
            return;
        }
        for (JsonNode diff : diffs) {
            String pkg;
            String oldPath = diff.get("old_path").asText();
            String newPath = diff.get("new_path").asText();
            String candidatePath = null;
            if (newPath != null && newPath.startsWith(resourcesPath)) {
                candidatePath = newPath;
            } else if (oldPath != null && oldPath.startsWith(resourcesPath)) {
                candidatePath = oldPath;
            }
            if (candidatePath == null || (pkg = GitLabDiffService.extractDirectory(resourcesPath, candidatePath)) == null || pkg.isBlank()) continue;
            boolean deleted = diff.get("deleted_file").asBoolean(false);
            if (deleted) {
                maybeDeletedPackages.add(pkg);
                continue;
            }
            changedPackages.add(pkg);
        }
        changedPackages.remove("menu");
    }

    public List<String> listFilesAtTag(String tag, String resourcesPath) throws IOException, InterruptedException {
        return this.listFilesRecursivePageByPage(this.projectId, tag, resourcesPath);
    }

    private List<String> listFilesRecursivePageByPage(String projectId, String tag, String path) throws IOException, InterruptedException {
        int pageNumber = 1;
        boolean hasNext = true;
        ArrayList<String> files = new ArrayList<String>();
        while (hasNext) {
            Object url = String.format("%s/projects/%s/repository/tree?recursive=true&ref=%s&per_page=100&page=%s", this.gitlabApi, projectId, tag, pageNumber);
            if (path != null && !path.isBlank()) {
                url = (String)url + "&path=" + URLEncoder.encode(path, StandardCharsets.UTF_8);
            }
            JsonNode json = this.callApi((String)url);
            for (JsonNode fileNode : json) {
                if (!"blob".equals(fileNode.get("type").asText())) continue;
                files.add(fileNode.get("path").asText());
            }
            if (json.size() == 0) {
                hasNext = false;
            }
            ++pageNumber;
        }
        return files;
    }

    private List<String> listFilesRecursive(String projectId, String tag, String path) throws IOException, InterruptedException {
        Object url = String.format("%s/projects/%s/repository/tree?ref=%s", this.gitlabApi, projectId, tag);
        if (path != null && !path.isBlank()) {
            url = (String)url + "&path=" + URLEncoder.encode(path, StandardCharsets.UTF_8);
        }
        JsonNode json = this.callApi((String)url);
        ArrayList<String> files = new ArrayList<String>();
        for (JsonNode fileNode : json) {
            if ("blob".equals(fileNode.get("type").asText())) {
                files.add(fileNode.get("path").asText());
                continue;
            }
            if (!"tree".equals(fileNode.get("type").asText())) continue;
            files.addAll(this.listFilesRecursive(projectId, tag, fileNode.get("path").asText()));
        }
        return files;
    }

    private static String extractDirectory(String basePath, String fullPath) {
        int lastSlash;
        String base;
        String normalized = fullPath.replace('\\', '/');
        if (!normalized.startsWith(base = basePath.replace('\\', '/'))) {
            return null;
        }
        String remainder = normalized.substring(base.length());
        if (remainder.startsWith("/")) {
            remainder = remainder.substring(1);
        }
        if ((lastSlash = remainder.lastIndexOf(47)) <= 0) {
            return null;
        }
        return remainder.substring(0, lastSlash);
    }

    private JsonNode callApi(String url) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + this.token).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("GitLab API failed: " + response.statusCode() + "\n" + response.body());
        }
        return this.mapper.readTree(response.body());
    }
}

